<div class="col-12">
    <form action="<?php echo e(route('admin.appointments.save')); ?>" method="POST" enctype="multipart/form-data" id="add-appointment-form"
        class="p-3 bg-white">
        <?php echo csrf_field(); ?>
        <div class="form-group row">
            <div class="col-12 col-lg-6 col-xl-4">
                <label class="col-form-label required" for="patients"><?php echo e(__('admin/appointments.form.patient')); ?></label>
                <select id="patients" name="patient" class="form-control selectpicker" data-live-search="true">
                    <option value="-1" disabled selected>-- Select --</option>
                    <?php $__currentLoopData = $patients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($patient->id); ?>" <?php if( $patient->id == old('patient')): ?> selected  <?php endif; ?>><?php echo e($patient->full_name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-12 col-lg-6 col-xl-4">
                <label class="col-form-label required" for="patient"><?php echo e(__('admin/appointments.form.branch')); ?></label>
                <select id="branches" name="branch" class="form-control selectpicker" data-live-search="true" disabled>
                </select>
            </div>
            <div class="col-12 col-lg-6 col-xl-4">
                <label class="col-form-label required" for="treatments"><?php echo e(__('admin/appointments.form.treatment')); ?></label>
                <select id="treatments" name="treatment" class="form-control selectpicker" data-live-search="true" disabled>
                </select>
            </div>
        </div>
        <div id="sessions-table" class="form-group row mt-5">
        </div>
    </form>


    <script>
        $(document).ready(function() {

            $(document).on('change','#patients', function() {

                let branch = this.value;

                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('admin.appointments.get_branches')); ?>",
                    dataType: "json",
                    beforeSend: function() {
                        $('#loading-overlay').addClass('is-active');
                    },
                    error: function(XMLHttpRequest) {
                        console.log(XMLHttpRequest.responseText);
                        $('#loading-overlay').removeClass('is-active');
                        $('#branches').attr('disabled');
                        
                    },
                    success: function(data) {
                        let html = '<option value="-1" disabled selected>-- Select --</option>';

                        $.each(data.treatments, function(index, value) {

                            html += '<option value="' + value.id + '">' + value.branch + '</option>'
                        });

                        $('#branches').html(html);

                        $('#branches').removeAttr('disabled');
                        $('#branches').selectpicker('refresh');
                        $('#sessions-table').html('');
                    },
                    complete: function(msg) {
                        $('#loading-overlay').removeClass('is-active');
                    }
                });


            });

            $(document).on('change','#branches', function() {

                let branch = this.value;

                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('admin.appointments.get_treatments')); ?>" + '/' + branch,
                    dataType: "json",
                    beforeSend: function() {
                        $('#loading-overlay').addClass('is-active');
                    },
                    error: function(XMLHttpRequest) {
                        console.log(XMLHttpRequest.responseText);
                        $('#loading-overlay').removeClass('is-active');
                        $('#treatments').attr('disabled');
                        
                    },
                    success: function(data) {
                        let html = '<option value="-1" disabled selected>-- Select --</option>';

                        $.each(data.treatments, function(index, value) {

                            html += '<option value="' + value.id + '">' + value.treatment + '</option>'
                        });

                        $('#treatments').html(html);

                        $('#treatments').removeAttr('disabled');
                        $('#treatments').selectpicker('refresh');
                        $('#sessions-table').html('');
                    },
                    complete: function(msg) {
                        $('#loading-overlay').removeClass('is-active');
                    }
                });


            });

            $(document).on('change','#treatments', function() {

                let treatment = this.value;
                let branch = $( "#branches option:selected" ).attr('value');
                let patient = $( "#patients option:selected" ).attr('value');

                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('admin.appointments.get_calendar')); ?>" + '/' + patient + '/' + branch + '/' + treatment + '/0',
                    dataType: "html",
                    cache: false,
                    beforeSend: function() {
                        $('#loading-overlay').addClass('is-active');
                    },
                    error: function(XMLHttpRequest) {
                        alert('error');
                        console.log(XMLHttpRequest);
                        $('#loading-overlay').removeClass('is-active'); 
                    },
                    success: function(data) {
                       $('#sessions-table').html(data);
                    },
                    complete: function(msg) {
                        $('#loading-overlay').removeClass('is-active');
                    }
                });
            });

        });
    </script>
</div>
<?php /**PATH /home/zainclinic83com/zain.app/resources/views/admin/appointments/add.blade.php ENDPATH**/ ?>