<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="robots" content="noindex">
    <title><?php echo e(config('app.name')); ?> | <?php echo e($_page_title); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset('plugins/fontawesome/css/fontawesome.min.css')); ?>">
    <?php if(app()->getLocale() == 'ar'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('fonts/noto/stylesheet.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('website/css/bootstrap.rtl.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('website/css/style-rtl.css')); ?>">
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(asset('fonts/roboto/roboto.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('website/css/bootstrap.min.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('website/css/style.css')); ?>">
    <?php endif; ?>
    <link href="<?php echo e(asset('website/css/aos.css')); ?>" rel="stylesheet" />

    <?php if($_css): ?>
        <?php $__currentLoopData = $_css; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <link rel="stylesheet" href="<?php echo e(asset('plugins/' . $item)); ?>">
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <script src="<?php echo e(asset('plugins/jquery/jquery-3.6.0.min.js')); ?>"></script>
</head>

<body class="bg-dark text-light">
    <?php if(!isset($_SERVER['HTTP_X_REQUESTED_WITH']) || $_SERVER['HTTP_X_REQUESTED_WITH'] != config('mobile_app.app_id')): ?>
        <?php echo $__env->make('patient.app.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
    <div class="container">
        <div id="page-alerts" class="row">
            <?php if($errors->any()): ?>
                <div id="error-alerts" class="col-12">
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <span><?php echo e($error); ?></span></br>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"
                            aria-label="Close"></button>
                    </div>
                </div>
            <?php endif; ?>
            <?php if(Session::has('error')): ?>
                <div id="error-alerts" class="col-12">
                    <div class="alert alert-warning alert-dismissible fade show" role="alert">
                        <span><?php echo e(Session::get('error')); ?></span>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"
                            aria-label="Close"></button>
                    </div>
                </div>
                <?php session()->pull('error'); ?>
            <?php endif; ?>
            <?php if(Session::has('success')): ?>
                <div class="col-12">
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <span><?php echo e(Session::get('success')); ?></span>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"
                            aria-label="Close"></button>
                    </div>
                </div>
                <?php session()->pull('success'); ?>
            <?php endif; ?>
            <?php if(Session::has('info')): ?>
                <div class="col-12">
                    <div class="alert alert-info alert-dismissible fade show" role="alert">
                        <span><?php echo e(Session::get('info')); ?></span>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"
                            aria-label="Close"></button>
                    </div>
                </div>
                <?php session()->pull('info'); ?>
            <?php endif; ?>
        </div>
    </div>

    <?php echo $__env->make($_page, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <footer class="bg-darker mt-4">
        <section id="contact-us" class="pt-5 bg-darker">
            <div class="container">
                <div class="row align-items-stretch">
                    <div class="col-12 col-lg-6 mx-auto">
                        
                        <div class="row social justify-content-between mt-5">
                            <?php if($_footer['social_accounts']): ?>
                                <?php $__currentLoopData = $_footer['social_accounts']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $account): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-6 col-md-4 col-lg-auto text-center mb-3">
                                        <a href="<?php echo e($account->link); ?>" class="text-center" title="<?php echo e($account->title); ?>"> 
                                            <i class="<?php echo e($account->icon); ?> fa-2x"></i><br>
                                            <span class="text-white fw-light"><?php echo e($account->username); ?></span>
                                        </a>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
        
        <div class="container-fluid text-center bg-dark-75 py-3">
            <span>جميع الحقوق محفوظة لمركز زين للتجميل &copy;</span>
        </div>
    </footer>
    <script src="<?php echo e(asset('website/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('website/js/aos.js')); ?>"></script>
    <script>
        let navbar = $('#main-navbar');
        let nav_brand = $('#main-navbar .navbar-brand img');

        //let $offset = $(window).height() - $('#main-navbar').height();
        let $offset = $(window).height();

        window.addEventListener('scroll', function() {

            if (window, pageYOffset < $offset) {
                navbar.addClass('bg-dark-50');
                navbar.removeClass('bg-darker');
            } else {
                navbar.removeClass('bg-dark-50');
                navbar.addClass('bg-darker');
            }
        });
    </script>
    <?php if($_js): ?>
        <?php $__currentLoopData = $_js; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <script src="<?php echo e(asset('plugins/' . $item)); ?>"></script>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <script>
        jQuery(function($) {
            AOS.init({
                once: true,
                duration: 1000
            });
        });
    </script>

    <?php if (! empty(trim($__env->yieldContent('scripts')))): ?>
        <?php echo $__env->yieldContent('scripts'); ?>
    <?php endif; ?>
</body>

</html>
<?php /**PATH /home/zainclinic83com/zain.app/resources/views/patient/app/app.blade.php ENDPATH**/ ?>