<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="robots" content="noindex">
    <title><?php echo e(config('app.name')); ?> | <?php echo e($_page_title); ?></title>
    <link rel="stylesheet" href="<?php echo e(asset('plugins/fontawesome/css/fontawesome.min.css')); ?>">
    <?php if(app()->getLocale() == 'ar'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('fonts/tajawal/stylesheet.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('admin/css/bootstrap-rtl.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('admin/css/admin-rtl.css')); ?>">
    <?php else: ?>
        <link rel="stylesheet" href="<?php echo e(asset('fonts/roboto/roboto.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('admin/css/bootstrap.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('admin/css/admin.css')); ?>">
    <?php endif; ?>
    <?php if($_css): ?>
        <?php $__currentLoopData = $_css; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <link rel="stylesheet" href="<?php echo e(asset('plugins/' . $item)); ?>">
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <script src="<?php echo e(asset('plugins/jquery/jquery-3.6.0.min.js')); ?>"></script>
</head>

<body class="hold-transition sidebar-mini-md sidebar-mini layout-fixed">
    <div class="wrapper">
        <?php echo $__env->make('admin.app.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->make('admin.app.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="content-wrapper">
            <section class="content">
                <div class="container-fluid px-lg-3 px-xl-4">
                    <div class="content-header row">
                        <div class="col-12 col-lg-6 px-1 my-auto">
                            <h1 class="m-0"><?php echo e($_page_title); ?></h1>
                        </div>
                        <div class="col-12 col-lg-6 px-1 my-auto text-right">
                            <!-- breadcrumbs -->
                            <?php echo $_breadcrumbs; ?>

                            <!-- ./breadcrumbs -->
                        </div>
                        <div class="col-12">
                            <hr class="mb-0">
                        </div>
                    </div>
                    <div class="content-body">
                        <div id="loading-overlay">
                            <span class="fas fa-spinner fa-3x fa-spin"></span>
                        </div>
                        <?php if($errors->any()): ?>
                            <div id="error-alerts" class="col-12">
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span><?php echo e($error); ?></span></br>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <button type="button" class="close" data-dismiss="alert"
                                        aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if(Session::has('danger')): ?>
                            <div id="error-alerts" class="col-12">
                                <div class="alert alert-danger alert-dismissible fade show" role="alert">

                                    <span><?php echo Session::get('danger'); ?></span></br>

                                    <button type="button" class="close" data-dismiss="alert"
                                        aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if(Session::has('success')): ?>
                            <div class="col-12">
                                <div class="alert alert-success alert-dismissible fade show" role="alert">
                                    <span><?php echo Session::get('success'); ?></span>
                                    <button type="button" class="close" data-dismiss="alert"
                                        aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php if(Session::has('info')): ?>
                            <div class="col-12">
                                <div class="alert alert-info alert-dismissible fade show" role="alert">
                                    <span><?php echo Session::get('info'); ?></span>
                                    <button type="button" class="close" data-dismiss="alert"
                                        aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            </div>
                        <?php endif; ?>
                        <?php echo $__env->make($_page, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </section>
        </div>
        <footer class="main-footer elevation-3">
            Developed By: <a href="https://auxiliumps.com" class="text-secondary">Au<b class="text-info">X</b>ilium Technology</a>
            
            <div class="float-right d-none d-sm-inline-block">
                This page took <?php echo e(microtime(true) - LARAVEL_START); ?> seconds to render
            </div>
        </footer>

        <div class="modal fade" id="action-confirm-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
            aria-labelledby="action-confirm-modal-label" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="action-confirm-modal-label">
                            <?php echo e(__('admin/common.confirm_modal.title')); ?>

                        </h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                    </div>
                    <div class="modal-footer d-lex justify-content-between">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="<?php echo e(asset('admin/js/bootstrap.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('admin/js/bootstrap.js')); ?>"></script>
    <?php if($_js): ?>
        <?php $__currentLoopData = $_js; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <script src="<?php echo e(asset('plugins/' . $item)); ?>"></script>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
    <script src="<?php echo e(asset('admin/js/admin.js')); ?>"></script>

    <div class="modal fade" id="confirm-delete-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
        aria-labelledby="confirm-delete-modal-label" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirm-delete-modal-label">
                        <?php echo e(__('admin/common.confirm_modal.delete_title')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <?php echo e(__('admin/common.confirm_modal.delete_msg')); ?>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary mr-auto" data-dismiss="modal"
                        title="<?php echo e(__('admin/common.buttons.cancel')); ?>"><?php echo e(__('admin/common.buttons.cancel')); ?></button>
                    <a href="#" class="btn btn-danger btn-confirm-delete"><?php echo e(__('admin/common.buttons.delete')); ?></a>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {

            $(document).on('change','.custom-file-input', function() {
                let fileName = $(this).val().substring($(this).val().indexOf(":") + 1);
                fileName = fileName.replace("\\fakepath\\", "");
                $(this).next('.custom-file-label').html(fileName);
            })

            $('.btn-delete').on('click', function(e) {

                e.preventDefault();

                let href = $(this).attr('data-href');

                $('#confirm-delete-modal .btn-confirm-delete').attr('href', href);

                $('#confirm-delete-modal').modal('show');

            });
        });
    </script>
    
</body>

</html>
<?php /**PATH /home/zainclinic83com/zain.app/resources/views/admin/app/app.blade.php ENDPATH**/ ?>