<div class="col-12">
    <div class="card bg-white p-3">
        <form action="<?php echo e(route('admin.treatment_categories.update',$category)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="form-group row mb-3">
                <div class="col-12 col-md-10 col-lg-8 col-xxl-6">
                    <label for="add-category" class="col-form-label required">
                        <?php echo e(__('admin/treatment_categories.form.name')); ?>

                    </label>
                    <input type="text" name="category" class="form-control" id="add-category"
                        value="<?php echo e(old('category',$category->name)); ?>">
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-md-10 col-lg-8 col-xxl-6">
                    <label for="description" class="col-form-label">
                        <?php echo e(__('admin/treatment_categories.form.description')); ?>

                    </label>
                    <textarea name="description" class="form-control" id="description" rows="5"><?php echo e(old('description',$category->description)); ?></textarea>
                </div>
            </div>
            <div class="form-group row mb-4">
                <div class="col-12 col-lg-6">
                    <label for="add-image" class="col-form-label">
                        <?php echo e(__('admin/treatment_categories.form.image')); ?>

                    </label>
                    <?php if($category->image): ?>
                        <div class="card elevation-0">
                            <div class="card-body">
                                <img id="category-img" src="<?php echo e(url(config('admin.public_uploads_dir') .'/' . $category->image)); ?>" style="max-width:300px"> 
                            </div>
                            <div class="card-footer">
                                <button id="remove-image" class="btn btn-danger btn-sm" type="button"><i class="fas fa-times"></i> <?php echo e(__('admin/common.buttons.delete')); ?></button>
                                <input name="no-image" type="hidden" id="no-image" value="<?php echo e($category->image); ?>">
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="input-group">
                        <div class="custom-file">
                            <input type="file" name="image" class="custom-file-input" id="treatment-categories-image"
                                aria-describedby="treatment-categories-image">
                            <label class="custom-file-label" for="treatment-categories-image">
                                <?php echo e(__('admin/common.buttons.browse')); ?>

                            </label>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group mt-3">
                <div class="custom-control custom-checkbox mb-2">
                    <input type="checkbox" name="shown" class="custom-control-input" value="1" id="is-shown" <?php if( old('shown',$category->show_on_public) ): ?> checked <?php endif; ?>>
                    <label class="custom-control-label" for="is-shown"><?php echo e(__('admin/treatment_categories.form.show_on_public')); ?></label>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-md-10 col-lg-8 col-xxl-6 ml-auto">
                    <?php if (isset($component)) { $__componentOriginal4604175501cb7c1ecd38fa23048239f7cbc8d477 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\Admin\Form\SaveButton::class, []); ?>
<?php $component->withName('admin.form.save-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4604175501cb7c1ecd38fa23048239f7cbc8d477)): ?>
<?php $component = $__componentOriginal4604175501cb7c1ecd38fa23048239f7cbc8d477; ?>
<?php unset($__componentOriginal4604175501cb7c1ecd38fa23048239f7cbc8d477); ?>
<?php endif; ?>
                </div>
            </div>
        </form>
        <script>
            $(document).ready(function () {
                $('#remove-image').on('click',function(){
                    $('#category-img').attr("src","");
                    $('#no-image').val("");
                });
            });
        </script>
    </div>
</div>
<?php /**PATH /home/zainclinic83com/zain.app/resources/views/admin/treatment_categories/edit.blade.php ENDPATH**/ ?>