<div class="col-12">
    <form id="pretest-form" action="<?php echo e(route('admin.pretests.save')); ?>" method="POST" enctype="multipart/form-data"
        id="add-appointment-form" class="p-3 bg-white">
        <?php echo csrf_field(); ?>
        <div class="form-group row">
            <div class="col-12 col-lg-6 col-xl-4">
                <label class="col-form-label required" for="patients"><?php echo e(__('admin/pretests.form.patient')); ?></label>
                <select id="patients" name="patient" class="form-control selectpicker" data-live-search="true">
                    <?php $__currentLoopData = $patients; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $patient): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($patient->id); ?>" <?php if($patient->id == old('patient')): ?> selected  <?php endif; ?>><?php echo e($patient->full_name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-12 col-lg-6 col-xl-4">
                <label class="col-form-label required" for="pretests"><?php echo e(__('admin/pretests.form.form')); ?></label>
                <select id="pretests" name="pretest" class="form-control selectpicker" data-live-search="true">
                    <?php $__currentLoopData = $pretests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pretest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($pretest->id); ?>" <?php if($pretest->id == old('pretest')): ?> selected  <?php endif; ?>><?php echo e($pretest->title); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-12 col-lg-6 col-xl-4 mt-auto pb-1">
                <button type="button" id="view-form"
                    class="btn btn-secondary btn-sm"><?php echo e(__('admin/pretests.view_form')); ?></button>
            </div>
        </div>
        <div id="pretest-form-content">
        </div>
    </form>
    <div class="modal fade" id="load-confirm-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
        aria-labelledby="load-confirm-modal-label" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="load-confirm-modal-label">
                        <?php echo e(__('admin/common.confirm_modal.title')); ?></h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <?php echo e(__('admin/common.confirm_modal.reload')); ?>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary"
                        data-dismiss="modal"><?php echo e(__('admin/common.buttons.close')); ?></button>
                    <button type="button"
                        class="btn btn-primary btn-confirm"><?php echo e(__('admin/common.buttons.reload')); ?></button>
                </div>
            </div>
        </div>
    </div>
    <script>
        $(document).ready(function() {

            $(document).on('click', '#view-form', function() {

                if ($('#pretest-form-content').children().length > 0) {
                    $('#load-confirm-modal').modal('show');
                } else {

                    loadForm()
                }

            });

            $('#load-confirm-modal .btn-confirm').on('click', function(e) {

                loadForm()
            });


            function loadForm() {
                let patient = $('#patients').val();
                let pretest_form = $('#pretests').val();

                $.ajax({
                    type: "GET",
                    url: "<?php echo e(route('admin.pretests.get_form')); ?>" + '/' + patient + '/' +
                        pretest_form,
                    dataType: "html",
                    beforeSend: function() {
                        $('#error-alerts').remove();
                        $('#pretest-form-content').html('');
                        $('#loading-overlay').addClass('is-active');
                    },
                    error: function(XMLHttpRequest) {
                        console.log(XMLHttpRequest.responseText);
                        $('#loading-overlay').removeClass('is-active');
                    },
                    success: function(data) {
                        $('#load-confirm-modal').modal('hide');
                        $('#pretest-form-content').html(data);
                    },
                    complete: function(msg) {
                        $('#loading-overlay').removeClass('is-active');
                    }
                });
            }



            $('#pretest-form').on('submit', function(e) {

                e.preventDefault();

                $('#pretest-modal .btn-save').attr("disabled", true);

                let form = $(this);

                let formData = new FormData(form[0]);


                /*    if ( $('#session-date').val() ){
                
                        formData.append('form-date',$('input[name="session-date"]').val() )
                    }else if( $('input[name="form-date"]').val() ){
                      
                        formData.append('form-date',$('form-date').val() )
                    } */
                if ($('.datetimepicker-input').val()) {

                    formData.append('form-date', $('.datetimepicker-input').val())
                }

                let url = form.attr('action')

                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    type: "POST",
                    url: url,
                    data: formData,
                    dataType: 'json',
                    contentType: false,
                    processData: false,
                    cache: false,
                    error: function(xhr) {
                        let parsed = JSON.parse(xhr.responseText);
                        console.log(parsed);

                        $('#error-alerts').remove();

                        let html = '<div id="error-alerts" class="col-12">';
                        html +=
                            '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
                        //$.each(parsed.error, function(key, err) {
                        html += '<span>' + parsed.error + '</span></br>';
                        //});
                        html +=
                            '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
                        html += '</div>';
                        html += '</div>';

                        $('.content-body').prepend(html);

                        $('#pretest-form .btn-save').attr("disabled", false);

                        $('html,body').animate({
                            scrollTop: 0
                        }, 'slow');
                    },
                    success: function(data) {
                        if (data.success) {
                            if (data.success) {
                                window.location.href =
                                    "<?php echo e(route('admin.pretests')); ?>";
                            }
                        }
                    }
                });
                return false;
            });

            $('body').on('focus', ".input-group.date", function() {
                var start_date = moment().subtract(5, "years").format("YYYY-MM-DD");
                $(this).datepicker({
                    format: 'yyyy-mm-dd',
                    endDate: '0d',
                    startdate: start_date,
                });
            });
        });
    </script>
</div>
<?php /**PATH /home/zainclinic83com/zain.app/resources/views/admin/pretests/add.blade.php ENDPATH**/ ?>