<div class=" col-12">
    <div class="card bg-white p-3">
        <form action="<?php echo e(route('admin.users.update', $user_info->id)); ?>" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col">
                    <h4><?php echo e(__('admin/users.text.user_info')); ?></h4>
                    <hr>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-6">
                    <label for="edit-first-name"
                        class="col-form-label required"><?php echo e(__('admin/users.form.first_name')); ?></label>
                    <input type="text" name="first-name" class="form-control" id="edit-first-name"
                        value="<?php echo e(old('first-name', $user_info->first_name)); ?>">
                </div>
                <div class="col-6">
                    <label for="edit-last-name"
                        class="col-form-label required"><?php echo e(__('admin/users.form.last_name')); ?></label>
                    <input type="text" name="last-name" class="form-control" id="edit-last-name"
                        value="<?php echo e(old('last-name', $user_info->last_name)); ?>">
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-6">
                    <label for="edit-mobile" class="col-form-label required">
                        <?php echo e(__('admin/users.form.mobile')); ?>

                        <small class="muted">(05xxxxxxx)</small>
                    </label>
                    <input type="text" name="mobile" class="form-control" id="edit-mobile"
                        value="<?php echo e(old('mobile', $user_info->mobile)); ?>">
                </div>
                <div class="col-6">
                    <label for="edit-email" class="col-form-label required"><?php echo e(__('admin/users.form.email')); ?></label>
                    <input type="text" name="email" class="form-control" id="edit-email"
                        value="<?php echo e(old('email', $user_info->email)); ?>">
                </div>
            </div>
            <div class="row mt-4">
                <div class="col">
                    <h4><?php echo e(__('admin/users.text.account_info')); ?></h4>
                    <hr>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-md-10 col-lg-6">
                    <label for="edit-role" class="col-form-label required"><?php echo e(__('admin/users.form.role')); ?></label>
                    <select name="role" class="form-control" id="edit-role">
                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($role->id); ?>" <?php echo e(old('role',$user_info->role_id) == $role->id ? "selected" : ""); ?>><?php echo e($role->role); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-12 col-md-10 col-lg-6" >
                    <label for="branches"
                        class="col-form-label required"><?php echo e(__('admin/users.form.branches')); ?></label>
                    <select name="branches[]" id="branches" class="form-control selectpicker" multiple>
                        <?php $__currentLoopData = $branches; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $branch): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($branch->id); ?>"><?php echo e($branch->branch); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-6">
                    <label for="edit-password" class="col-form-label required">
                        <?php echo e(__('admin/users.form.password')); ?>

                        <small class="muted">(8 chars minimum)</small>
                    </label>
                    <input type="text" name="password" class="form-control" id="edit-password"
                        value="<?php echo e(old('password')); ?>">
                </div>
                <div class="col-6">
                    <label for="edit-cpassword"
                        class="col-form-label required"><?php echo e(__('admin/users.form.cpassword')); ?></label>
                    <input type="text" name="cpassword" class="form-control" id="edit-cpassword"
                        value="<?php echo e(old('cpassword')); ?>">
                </div>
            </div>
            <div class="form-group">
                <div class="custom-control custom-checkbox mb-2">
                    <input type="checkbox" name="blocked" class="custom-control-input"
                        <?php echo e(old('blocked', $user_info->is_blocked) ? 'checked' : ''); ?> value="1" id="is-blocked">
                    <label class="custom-control-label" for="is-blocked">Account is blocked</label>
                </div>
                <div class="custom-control custom-checkbox mb-2">
                    <input type="checkbox" name="notify" class="custom-control-input"
                        <?php echo e(old('notify') ? 'checked' : ''); ?> value="1" id="notify">
                    <label class="custom-control-label" for="notify">send the user login details via
                        email</label>
                </div>
            </div>
            <div class="form-group row">
                <?php if (isset($component)) { $__componentOriginal4604175501cb7c1ecd38fa23048239f7cbc8d477 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\Admin\Form\SaveButton::class, []); ?>
<?php $component->withName('admin.form.save-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes(['title' => ''.e(__('admin/common.btn.save')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4604175501cb7c1ecd38fa23048239f7cbc8d477)): ?>
<?php $component = $__componentOriginal4604175501cb7c1ecd38fa23048239f7cbc8d477; ?>
<?php unset($__componentOriginal4604175501cb7c1ecd38fa23048239f7cbc8d477); ?>
<?php endif; ?>
            </div>
        </form>
    </div>

    <script>
        $(document).ready(function(){

            $('#is-physician').change(function() {
                $('#user-services').toggle('fast');
            });

            $('#branches').selectpicker('val', ['<?php echo $selected_branches; ?>']);
            $('#branches').selectpicker('refresh');;
            
        });
    </script>
</div>
<?php /**PATH /home/zainclinic83com/zain.app/resources/views/admin/users/edit.blade.php ENDPATH**/ ?>