<nav id="main-navbar" class="navbar navbar-expand-lg navbar-dark <?php if(Request::route()->getName() == 'website.home'): ?> fixed-top bg-dark-50 <?php else: ?> bg-darker <?php endif; ?>">
    <div class="container-fluid">
        <a class="navbar-brand" href="<?php echo e(url('/patient')); ?>">
            <img src="<?php echo e(asset(config('website.logo'))); ?>" alt="<?php echo e(config('app.name')); ?>">
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#main-nvabr-collapse"
            aria-controls="main-nvabr-collapse" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="main-nvabr-collapse">
             <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                <li class="nav-item">
                    <a class="nav-link active" aria-current="page"
                        href="<?php echo e(url('/patient')); ?>"><?php echo e(__('website/navbar.home')); ?>

                    </a>
                </li>
               
            </ul> 
            <div class="navbar-nav ms-lg-auto me-4">
                
                    
                
                
                    <?php if(Session::has('patient_info')): ?>
                        <a class="nav-link dropdown-toggle" href="#" id="navbar-user-profile" role="button"
                            data-bs-toggle="dropdown" aria-expanded="false">
                            <?php echo e(Session::get('patient_info.name')); ?>

                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbar-user-profile">
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('patient.dashboard')); ?>">
                                    <?php echo e(__('website/navbar.dashboard')); ?>

                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('patient.appointments')); ?>">
                                    <?php echo e(__('website/navbar.appointments')); ?>

                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('patient.complaints')); ?>">
                                    <?php echo e(__('website/navbar.complaints')); ?>

                                </a>
                            </li>
                            <li>
                                <hr class="dropdown-divider" />
                            </li>
                            
                            <li>
                                <a class="dropdown-item" href="<?php echo e(route('patient.logout')); ?>">
                                    <?php echo e(__('website/navbar.logout')); ?>

                                </a>
                            </li>
                        </ul>
                    <?php else: ?>
                    
                    <a class="nav-link text-sm" href="<?php echo e(route('patient.login')); ?>">
                        <?php echo e(__('website/navbar.login')); ?>

                    </a>
                    
                <?php endif; ?>
                
            </div>
        </div>
    </div>
</nav>








<?php /**PATH /home/zainclinic83com/zain.app/resources/views/patient/app/navbar.blade.php ENDPATH**/ ?>