<?php

use App\Http\Controllers\Api\Branches;
use App\Http\Controllers\Api\Patients;
use App\Http\Controllers\Api\Treatments;
use App\Http\Controllers\Api\Appointments;
use App\Http\Controllers\Api\Complaints;
use App\Http\Controllers\Api\ContactUs;
use App\Http\Controllers\Api\Offers;
use App\Http\Controllers\Api\PatientNotifications;
use App\Http\Controllers\Api\Regions;
use App\Http\Controllers\Api\Reviews;
use App\Http\Controllers\Api\SocialAccounts;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

//Route::get('patient/info/{id}', [Patients::class,'getPatient'])->name('info');

Route::name('api')->where(['locale' => '[a-zA-Z]{2}'])->middleware(['api_locale'])->group(function() {

    //---------------
    // Public routes
    //---------------
    
    Route::post('/login', [Patients::class,'login'])->name('.do_login');
    // no need for 'GET' route, but its added to avoid route unknown message
    Route::get('/login', [Patients::class,'login'])->name('.login');

    Route::post('/register', [Patients::class,'register'])->name('.register');

    //Route::post('/validate', [Patients::class,'validateRegisterForm'])->name('.validate');

    Route::post('/verify', [Patients::class,'verify'])->name('.verify');

    Route::post('/reset', [Patients::class,'resetPassword'])->name('.reset');


    Route::get('/social-accounts/list',[SocialAccounts::class,'list'])->name('.social_accounts.list');


    Route::prefix('regions')->name('.regions')->group(function(){

        Route::get('/list', [Regions::class,'getRegions'])->name('.list');
    
    });

    Route::prefix('offers')->name('.offers')->group(function(){

        Route::get('/list', [Offers::class,'list'])->name('.list');
        Route::get('/info/{offer_id}', [Offers::class,'info'])->name('.info');

    });


    Route::post('/contact/send', [ContactUs::class,'send'])->name('.contact.send');

    Route::prefix('branches')->name('.branches')->group(function(){

        Route::get('/get-branches', [Branches::class,'getBranches'])->name('.list');
        
        Route::get('/get-branches-dropdown', [Branches::class,'getBranchesDropdown'])->name('.dropdown');

    });

    //-------------------
    // Protected routes
    //-------------------
    Route::middleware('auth:sanctum')->group(function(){

        Route::get('/get-timestamp', function(){
            return response()->json(['date' => now()],200);
        });

        Route::prefix('patients')->name('.patients')->group(function(){

            Route::get('/info/{id}', [Patients::class,'getPatient'])->name('.info');
            Route::post('/set-device-token', [Patients::class,'setDeviceToken'])->name('.set_device_token');
            Route::post('/update/{patient_id}', [Patients::class,'update'])->name('.update');
            //Route::post('/validate-update/{patient_id}', [Patients::class,'validateUpdate'])->name('.validate_update');

            Route::get('/logout/{patient_id}', [Patients::class,'logout'])->name('.logout');

            Route::get('/notifications/{patient_id}', [PatientNotifications::class,'getPatientNotifications'])->name('.notifications');

            Route::get('/notification/set-as-read/{notification_id}', [PatientNotifications::class,'setAsRead'])->name('.notifications.set_as_read');
        });

      

        Route::prefix('treatments')->name('.treatments')->group(function(){

            Route::get('/category-by-branch/{id}', [Treatments::class,'getTreatmentCategoriesByBranch'])->name('.cat_by_branch');
            
            Route::get('/by-category/{id}', [Treatments::class,'getCategoryTreatments'])->name('.by_cat');

            Route::get('/info/{treatment_id}', [Treatments::class,'getTreatmentInfo'])->name('.info');

        });

        Route::prefix('appointments')->name('.appointments')->group(function(){

            Route::get('/free/{patient_id}/{branch_id}/{treatment_id}', [Appointments::class,'getAppointmentsCalendar'])->name('.free');
            
            Route::post('/add', [Appointments::class,'addAppointment'])->name('.add');

            Route::post('/update/{appointment_id}', [Appointments::class,'postponeAppointment'])->name('.update');

            Route::get('/info/{appointment_id}', [Appointments::class,'getAppointmentInfo'])->name('.info');

            Route::get('/patient/{patient_id}', [Appointments::class,'getPatientAppointments'])->name('.patient');

            Route::get('/cancel/{appointment_id}', [Appointments::class,'cancelAppointment'])->name('.cancel');

            //Route::get('/list/{patient_id}', [Appointments::class,'getPatientAppointments'])->name('.list');

        });
        Route::prefix('complaints')->name('.complaints')->group(function(){

            Route::get('/list/{patient_id}', [Complaints::class,'patientComplaints'])->name('.list');

            Route::post('/add', [Complaints::class,'addComplaint'])->name('.add');

            Route::get('/download/{complaint_id}', [Complaints::class,'downloadAttachment'])->name('.download');
        });

        Route::prefix('reviews')->name('.reviews')->group(function(){

            Route::post('/add', [Reviews::class,'add'])->name('.add');
        });
    });  
});

Route::fallback(function() {
    return response()->json(['error'=>'Link not found 404'],404);
});


/* Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
}); */
