<div id="patient-dashboard-menu" class="col-12 col-md-6 col-lg-4 col-xl-2">
    <div class="card bg-dark-75 border-0 card-bg">
        <div class="card-header bg-dark-75 border-bottom border-secondary">
            <span class="h5 header-title">
                {{ $patient->full_name }}
            </span>
        </div>
        <div class="card-body px-0 pb-0">
            <div class="px-3">
                <table class="table table-borderless text-light">
                    <tbody class="text-sm">
                        <tr>
                            <td>{{ __('patient/dashboard.info.dob') }}:</td>
                            <td><span class="text-sm fw-light">{{ $patient->formatted_dob }}</span></td>
                        </tr>
                        <tr>
                            <td>{{ __('patient/dashboard.info.age') }}:</td>
                            <td><span class="text-sm fw-light">{{ $patient->age }}</span></td>
                        </tr>
                        <tr>
                            <td>{{ __('patient/dashboard.info.gender') }}:</td>
                            <td><span class="text-sm fw-light">{{ $patient->full_gender }}</span></td>
                        </tr>
                        <tr>
                            <td>{{ __('patient/dashboard.info.region') }}:</td>
                            <td><span class="text-sm fw-light">{{ $patient->region->region }}</span></td>
                        </tr>
                        <tr>
                            <td>{{ __('patient/dashboard.info.address') }}:</td>
                            <td><span class="text-sm fw-light">{{ $patient->address }}</span></td>
                        </tr>
                        <tr>
                            <td>{{ __('patient/dashboard.info.mobile') }}:</td>
                            <td><span class="text-sm fw-light">{{ $patient->mobile }}</span></td>
                        </tr>
                        <tr>
                            <td>{{ __('patient/dashboard.info.email') }}:</td>
                            <td><span class="text-sm fw-light">{{ $patient->email }}</span></td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="list-group bg-dark-75">
                @if ($active == route('patient.dashboard'))
                    <a href="{{ route('patient.dashboard') }}"
                        class="list-group-item list-group-item-action text-white active" aria-current="true">
                    @else
                        <a href="{{ route('patient.dashboard') }}"
                            class="list-group-item list-group-item-action text-white">
                @endif
                {{ __('website/patient/dashboard.title') }}
                </a>

                @if ($active == route('patient.appointments'))
                    <a href="{{ route('patient.appointments') }}"
                        class="list-group-item list-group-item-action active text-white" aria-current="true">
                    @else
                        <a href="{{ route('patient.appointments') }}"
                            class="list-group-item list-group-item-action text-white">
                @endif
                {{ __('website/patient/appointments.title') }}
                </a>

                @if ($active == route('patient.complaints'))
                    <a href="{{ route('patient.complaints') }}"
                        class="list-group-item list-group-item-action active text-white" aria-current="true">
                    @else
                        <a href="{{ route('patient.complaints') }}"
                            class="list-group-item list-group-item-action text-white">
                @endif
                {{ __('website/patient/complaints.title') }}
                </a>

                {{-- @if ($active == route('patient.account'))
                    <a href="{{ route('patient.account') }}"
                        class="list-group-item list-group-item-action active text-white" aria-current="true">
                    @else
                        <a href="{{ route('patient.account') }}"
                            class="list-group-item list-group-item-action text-white">
                @endif
                {{ __('website/patient/account.title') }}
                </a>
 --}}
            </div>
        </div>
    </div>
</div>
