<div class="container-fluid px-5">
    <div class="row mt-5">
        @include('patient.sidebar', ['active' => route('patient.appointments') ])
        <div class="col bg-dark-75 py-4">
            <div class="row">
                <x-patient.table.search :action="$search_form_action" :keywords="$search" />
                <x-patient.table.rows-per-page :selected="$rows" />
                <x-patient.form.reset-button link="{{ route('patient.appointments') }}" />
                <x-patient.form.add-button title="{{ __('admin/appointments.btn.add') }}"
                    link="{{ route('patient.appointments.add') }}" />
            </div>
            <div class="row">
                <x-patient.table.table :rows="$result" :columns="$columns" base-link="{{ $route_key }}"
                    :action-buttons="['info_modal','postpone','delete']" />
            </div>
        </div>
    </div>
    <div id="app-info-card"></div>
    <script>
        $(document).ready(function() {

            $('.btn-info-modal').on('click', function(e) {

                e.preventDefault();

                let row_id = $(this).attr('data-row-id');

                $.ajax({
                    type: "GET",
                    url: "{{ route($route_key) }}/info/" + row_id,
                    dataType: "html",
                    beforeSend: function() {
                        $('#loading-overlay').addClass('is-active');
                    },
                    error: function(XMLHttpRequest) {
                        alert('error');
                        $('#loading-overlay').removeClass('is-active');
                    },
                    success: function(data) {
                        $('#app-info-card').html(data);
                        $('#loading-overlay').removeClass('is-active');
                        $('#info-modal').modal('show');
                    },
                });

            });

        });
    </script>

    <div class="modal fade" id="confirm-delete-modal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
        aria-labelledby="confirm-delete-modal-label" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content bg-dark text-white">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirm-delete-modal-label">
                        {{ __('admin/common.confirm_modal.delete_title') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    {{ __('admin/common.confirm_modal.delete_msg') }}
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary mr-auto" data-bs-dismiss="modal"
                        title="{{ __('admin/common.buttons.cancel') }}">{{ __('admin/common.buttons.cancel') }}</button>
                    <a href="#" class="btn btn-danger btn-confirm-delete">{{ __('admin/common.buttons.delete') }}</a>
                </div>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $('.btn-delete').on('click', function(e) {

                e.preventDefault();

                let href = $(this).attr('data-href');

                $('#confirm-delete-modal .btn-confirm-delete').attr('href', href);

                $('#confirm-delete-modal').modal('show');

            });
        });
    </script>
</div>
