<div class="col">
    <table class="table table-bordered table-hover">
        <thead class="bg-light">
            <tr>
                <th class="fit text-center">#</th>
                @foreach ($columns as $col)
                    {!! $col !!}
                @endforeach
                <th class="text-center">{{ __('admin/common.cols.actions') }}</th>
            </tr>
        </thead>
        <tbody class="bg-white">
            @if ($rows)
                @foreach ($rows as $index => $row)
                    <tr>
                        <td class="text-center">{{ $first_index++ }}</td>
                        @foreach ($columns as $key => $col)
                            <td>{{ $row[$key] }}</td>
                        @endforeach
                        <td class="fit text-right">
                            @if ($groupButtons)
                                <div class="dropdown">
                                    <button class="btn btn-secondary dropdown-toggle" type="button"
                                        id="action-bittons-dropdown" data-toggle="dropdown" aria-haspopup="true"
                                        aria-expanded="false">
                                        <i class="fas fa-ellipsis-v"></i>
                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="action-bittons-dropdown">
                                        @foreach ($actionButtons as $button)
                                            <a class="dropdown-item" href="#">
                                                @switch($button)
                                                    @case('info')
                                                        <x-admin.form.info-button link="{{ route($baseLink) }}"
                                                            id="{{ $row['id'] }}" />
                                                    @break
                                                    @case('edit')
                                                        <x-admin.form.edit-button link="{{ route($baseLink) }}"
                                                            id="{{ $row['id'] }}" />
                                                    @break
                                                    @case('delete')
                                                        <x-admin.form.delete-button link="{{ route($baseLink) }}"
                                                            id="{{ $row['id'] }}" />
                                                    @break
                                                    @case('info_modal')
                                                        <x-admin.form.info-modal-button id="{{ $row['id'] }}" />
                                                    @break
                                                    @case('check_in')
                                                        <x-admin.form.check-in-button link="{{ route($baseLink) }}"
                                                            id="{{ $row['id'] }}" />
                                                    @break
                                                    @case('postpone')
                                                        <x-admin.form.postpone-button link="{{ route($baseLink) }}"
                                                            id="{{ $row['id'] }}" />
                                                    @break
                                                    @default
                                                @endswitch
                                            </a>
                                        @endforeach
                                    </div>
                                </div>
                            @else
                                @foreach ($actionButtons as $button)
                                    @switch($button)
                                        @case('info')
                                            <x-admin.form.info-button link="{{ route($baseLink) }}"
                                                id="{{ $row['id'] }}" />
                                        @break
                                        @case('edit')
                                            <x-admin.form.edit-button link="{{ route($baseLink) }}"
                                                id="{{ $row['id'] }}" />
                                        @break
                                        @case('delete')
                                            <x-admin.form.delete-button link="{{ route($baseLink) }}"
                                                id="{{ $row['id'] }}" />
                                        @break
                                        @case('info_modal')
                                            <x-admin.form.info-modal-button id="{{ $row['id'] }}" />
                                        @break
                                        @case('check_in')
                                            <x-admin.form.check-in-button link="{{ route($baseLink) }}"
                                                id="{{ $row['id'] }}" />
                                        @break
                                        @case('postpone')
                                            <x-admin.form.postpone-button link="{{ route($baseLink) }}"
                                                id="{{ $row['id'] }}" />
                                        @break
                                        @default
                                    @endswitch
                                @endforeach
                            @endif
                        </td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td colspan="{{ count($columns) + 2 }}" class="text-center">
                        {{ __('admin/common.msgs.no_results') }}
                    </td>
                </tr>
            @endif
        </tbody>
    </table>
    @if ($rows)
        <div class="row mt-3 pb-5">
            <div class="col-12 col-lg-auto my-auto">
                <span class="font-italic text-sm">
                    {{ $pagination['msg'] }}
                </span>
            </div>
            <div class="col-12 col-lg-auto ml-auto">
                {{ $pagination['links'] }}
            </div>
        </div>

        <div class="modal fade" id="confirm-delete-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
            aria-labelledby="confirm-delete-modal-label" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="confirm-delete-modal-label">
                            {{ __('admin/common.confirm_modal.title') }}</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        {{ __('admin/common.confirm_modal.delete_msg') }}
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary mr-auto" data-dismiss="modal"
                            title="{{ __('admin/common.buttons.cancel') }}">{{ __('admin/common.buttons.cancel') }}</button>
                        <a href="#"
                            class="btn btn-danger btn-confirm-delete">{{ __('admin/common.buttons.delete') }}</a>
                    </div>
                </div>
            </div>
        </div>

    @endif

    <script>
        $(document).ready(function() {

            $('.btn-delete').on('click', function(e) {

                e.preventDefault();

                let href = $(this).attr('data-href');

                $('#confirm-delete-modal .btn-confirm-delete').attr('href', href);

                $('#confirm-delete-modal').modal('show');

            });



            $('.btn-filter').on('click', function(e) {

                //let url = window.location.href.split('?')[0];
                let url = '{{ route($baseLink) }}';

                // get rows
                let rows = $('#table-rows-per-page').val();

                if (rows) {
                    url += '?rows=' + rows;
                }

                //get filters
                let filter = $('#table-row-filters').val();

                if (filter) {
                    url += '&filter=' + filter;
                }

                //get search
                let search = $('#table-search').val();

                if (search) {
                    url += '&search=' + search;
                }

                // get sort by
                let sort = $('table th[sorted]').first().attr('data-sort');

                if (sort) {
                    url += '&sort=' + sort;
                }

                // get order by
                let order = $('table th[sorted]').first().attr('data-order');

                if (order) {
                    url += '&order=' + order;
                }

                window.location.href = url;
            });
        });
    </script>
</div>