<div class="col-12">
    <div class="card bg-white p-3">
        <form action="{{ route('admin.users.save') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="col">
                    <h4>{{ __('admin/users.text.user_info')}}</h4>
                    <hr>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-6">
                    <label for="add-first-name"
                        class="col-form-label required">{{ __('admin/users.form.first_name') }}</label>
                    <input type="text" name="first-name" class="form-control" id="add-first-name"
                        value="{{ old('first-name') }}">
                </div>
                <div class="col-6">
                    <label for="add-last-name"
                        class="col-form-label required">{{ __('admin/users.form.last_name') }}</label>
                    <input type="text" name="last-name" class="form-control" id="add-last-name"
                        value="{{ old('last-name') }}">
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-6">
                    <label for="add-mobile" class="col-form-label required">
                        {{ __('admin/users.form.mobile') }}
                        <small class="muted">(05xxxxxxx)</small>
                    </label>
                    <input type="text" name="mobile" class="form-control" id="add-mobile"
                        value="{{ old('mobile') }}">
                </div>
                <div class="col-6">
                    <label for="add-email" class="col-form-label required">{{ __('admin/users.form.email') }}</label>
                    <input type="text" name="email" class="form-control" id="add-email" value="{{ old('email') }}">
                </div>
            </div>
            <div class="row mt-4">
                <div class="col">
                    <h4>{{ __('admin/users.text.account_info')}}</h4>
                    <hr>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-md-10 col-lg-6">
                    <label for="add-role" class="col-form-label required">{{ __('admin/users.form.role') }}</label>
                    <select name="role" class="form-control" id="add-role">
                        @foreach ($roles as $role)
                            <option value="{{ $role->id }}" {{ old('role') == $role->id ? "selected" : "" }}>{{ $role->role }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-12 col-md-10 col-lg-6" >
                    <label for="branches"
                        class="col-form-label required">{{ __('admin/users.form.branches') }}</label>
                    <select name="branches[]" id="branches" class="form-control selectpicker" multiple>
                        @foreach ($branches as $branch)
                            <option value="{{ $branch->id }}">{{ $branch->branch }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-6">
                    <label for="add-password" class="col-form-label required">
                        {{ __('admin/users.form.password') }}
                        <small class="muted">(8 chars minimum)</small>
                    </label>
                    <input type="text" name="password" class="form-control" id="add-password"
                        value="{{ $gen_password }}">
                </div>
                <div class="col-6">
                    <label for="add-cpassword"
                        class="col-form-label required">{{ __('admin/users.form.cpassword') }}</label>
                    <input type="text" name="cpassword" class="form-control" id="add-cpassword"
                        value="{{ $gen_password }}">
                </div>
            </div>
            <div class="form-group">
                <div class="custom-control custom-checkbox mb-2">
                    <input type="checkbox" name="blocked" class="custom-control-input" value="1" id="is-blocked">
                    <label class="custom-control-label" for="is-blocked">Account is blocked</label>
                </div>
                <div class="custom-control custom-checkbox mb-2">
                    <input type="checkbox" name="notify" class="custom-control-input" value="1" id="notify">
                    <label class="custom-control-label" for="notify">send the user login details via
                        email</label>
                </div>
            </div>
            <div class="form-group row">
                <x-admin.form.save-button title="{{ __('admin/common.btn.save') }}" />
            </div>
        </form>
    </div>
    <script>
        $(document).ready(function(){
            $('#is-physician').change(function() {
                $('#user-services').toggle('fast');
            });
            
        });
    </script>
</div>
