<div class="col-12">
    <div class="card bg-white p-3">
        <form action="{{ route('admin.roles.save') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-group row mb-4">
                <div class="col-12 col-lg-6">
                    <label for="add-roles"
                        class="col-auto col-form-label required">{{ __('admin/roles.form.role') }}</label>
                    <div class="col">
                        <input type="text" name="role" class="form-control" id="add-roles" value="{{ old('role') }}">
                    </div>
                </div>
                <div class="col-12 col-lg-6">
                    <label for="add-dashboard" class="col-auto col-form-label required">
                        {{ __('admin/roles.form.dashboard') }}
                    </label>
                    <div class="col">
                        <select name="dashboard" id="add-dashboard" class="form-control">
                            @foreach ( (array)config('admin.dashboards') as $key => $dashboard)
                                <option value="{{ $key }}" {{ old('dashboard') == $key ? 'selected' : '' }}>
                                    {{ __('admin/roles.dashboards.'.$dashboard) }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
            </div>
            <div class="form-group">
                @if ($permissions)
                    <table id="permissions" class="table table-bordered table-responsive">
                        <tbody>
                            @foreach ($permissions as $controller => $methods)
                                <tr>
                                    <td class="fit">
                                        <div class="custom-control custom-checkbox">
                                            <input type="checkbox" class="custom-control-input check-all"
                                                id="{{ $controller }}">
                                            <label class="custom-control-label font-weight-bold"
                                                for="{{ $controller }}">
                                                {{ __('admin/permissions.controllers.' . $controller) }}
                                                {{-- {{ __('admin/' . $controller . '.title') }} --}}
                                            </label>
                                        </div>
                                    </td>
                                    @foreach ($methods as $method)
                                        <td>
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input {{ $controller }}"
                                                    name="permissions[]" value="{{ $method->id }}"
                                                    id="{{ $controller . '_' . $method->id }}">
                                                <label class="custom-control-label"
                                                    for="{{ $controller . '_' . $method->id }}">
                                                    {{ __('admin/permissions.methods.' . $method->method_lang_key) }}
                                                </label>
                                            </div>
                                        </td>
                                    @endforeach
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                @endif
            </div>
            <div class="form-group row">
                <x-admin.form.save-button title="{{ __('admin/common.btn.save') }}" />
            </div>
        </form>
    </div>
    <script>
        $(document).ready(function() {
            $('.check-all').on('change', function(e) {

                let _id = $(this).attr('id');

                if ($(this).is(":checked")) {

                    $('#permissions').find('.' + _id).each(function() {
                        $(this).prop('checked', true);
                    });
                } else {
                    $('#permissions').find('.' + _id).each(function() {
                        $(this).prop('checked', false);
                    });
                }
            });
        });
    </script>

</div>
