<div class="col-12 text-right mb-2">
    @if ( $complaint->is_resolved == 1)
        <a href="{{ route('admin.complaints.resolved',$complaint) }}" class="btn btn-sm btn-danger ml-2">
            <i class="fas fa-times"></i>
            {{ __('admin/complaints.btn.not_resolved') }}
        </a>
    @else
        <a href="{{ route('admin.complaints.resolved',$complaint) }}" class="btn btn-sm btn-success ml-2">
            <i class="fas fa-check"></i>
            {{ __('admin/complaints.btn.resolved') }}
        </a>
    @endif
    
</div>
<div class="col-12 pb-3">
    <div class="card w-100 border elevation-0">
        <div class="card-body">
            <div class="d-flex w-100 justify-content-between">
                <small class="mt-3 text-muted">{{ __('admin/complaints.columns.is_resolved') }}:
                    {!! $complaint->status !!}</small>
                <small class="mt-3 text-muted">{{ __('admin/complaints.columns.complaint_date') }}:
                    {{ $complaint->complaint_date->format('Y-m-d') }}</small>
                <small class="mt-3 text-muted">{{ __('admin/complaints.columns.created_at') }}:
                    {{ $complaint->created_time }}</small>
            </div>
            <hr>
            <div class="w-100 mt-4">
                <p>{{ $complaint->description }}</p>
            </div>

            <div class="d-flex w-100 justify-content-start pt-2 mt-5 border-top">
                <button type="button" class="btn btn-sm btn-purple" data-toggle="modal"
                    data-target="#patient-info-modal">
                    <i class="fas fa-exclamation-circle"></i>
                    {{ __('admin/complaints.btn.patient_info') }}
                </button>
                <a href="{{ route('admin.appointments',['pid'=>$patient->id]) }}" class="btn btn-sm btn-secondary ml-2"
                    target="_blank">
                    <i class="fas fa-calendar-alt"></i>
                    {{ __('admin/complaints.btn.history') }}
                </a>
                @if ($complaint->attachment)
                    <span class="font-weight-bold my-auto ml-auto mr-3">
                        {{ __('admin/complaints.columns.attachment') }}
                    </span>
                    <a href="{{ route('admin.complaints.download', $complaint->id) }}" class="btn btn-sm btn-info"
                        target="_blank">
                        <i class="fas fa-file-download"></i>
                    </a>
                @endif
            </div>
        </div>
    </div>
</div>
<div class="col-12">
    <div class="card text-dark">
        <div class="card-body p-4">
            <h4 class="mb-2">{{ __('admin/complaint_comments.title') }}</h4>
            <hr class="mb-4">
            @if ( $comments->count() )
                @foreach ($comments as $comment)
                    <div class="pt-3">
                        <h6 class="mb-1">{{ $comment->user->full_name }}</h6>
                        <div class="d-flex align-items-center mb-4">
                            <p class="mb-0 text-sm text-muted">
                                {{ $comment->comment_time }}
                            </p>
                        </div>
                        <p class="mb-0">
                            {{ $comment->comment }}
                        </p>
                    </div>
                    <hr class="mb-3">
                @endforeach
            @else
            <div class="w-100 text-center">
                <span>{{ __('admin/complaint_comments.no_comments') }}</span>
            </div>
            @endif
        </div>
    </div>
</div>
<div class="col-12">
    <div class="card">
        <div class="card-body">
            <form action="{{ route('admin.complaints.add_comment')}}" method="post" enctype="multipart/form-data" id="add-comment-form">
                @csrf
                <textarea class="form-control" name="comment" id="comment" rows="5" placeholder="Write a comment...">{{ old('comment') }}</textarea>
                <div class="text-right">
                    <button type="submit" id="add-comment" class="btn btn-primary mt-3">Send</button>
                </div>
                <input name="complaint-id" type="hidden" value="{{ $complaint->id }}">
            </form>
        </div>
    </div>
</div>

<div class="modal fade" id="patient-info-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
    aria-labelledby="patient-info-modal-label" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="patient-info-modal-label">{{ $patient->getFullName() }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="card w-100 elevation-0 mb-0">
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tbody>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients_info.fields.full_name') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->getFullNameAttribute() }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients_info.fields.age') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->getAgeAttribute() }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients_info.fields.gender') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->getGender() }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients_info.fields.region') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->region->region }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients_info.fields.address') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->address }}</span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm"
                    data-dismiss="modal">{{ __('admin/common.buttons.close') }}</button>
            </div>
        </div>
    </div>
</div>


<script>
    $(document).ready(function() {

        

       
    });
</script>
