@if ($result)
    <div class="table-toolbar col mb-3">
        <div class="row">
            <x-admin.table.search :action="$search_form_action" :keywords="$search" />
            <x-admin.table.rows-per-page :selected="$rows" />
            <x-admin.form.reset-button link="{{ route('admin.reports.appointments') }}" />
            {{-- <div class="dropdown ml-auto px-3">
                <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="print-dropdown-menu"
                    data-toggle="dropdown" aria-expanded="false">
                    <i class="fas fa-print"></i>
                </button>
                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="print-dropdown-menu">
                    <a class="dropdown-item" target="_blank" href="{{ $print_all }}">All Records</a>
                    <a class="dropdown-item" target="_blank" href="{{ $print_current }}">Current Selection</a>
                </div>
            </div> --}}
        </div>
        <form class="row mt-3 d-flex" name="appointments-report-filters" action="{{ $filter_link }}" method="GET"
            enctype="multipart/form-data">
            {{-- Filter by treatment --}}
            <div class="col-12 col-lg-3 col-xl-2 mb-lg-0">
                <label for="table-treatments-filter">{{ __('admin/reports.appointments.columns.treatment') }}</label>
                <select name="treatments-filter" class="form-control selectpicker" data-live-search="true"
                    id="table-treatments-filter">
                    <option value="" selected>-</option>
                    @foreach ($treatments as $treatment)
                        @if ($treatment->id == $selected_treatment)
                            <option value="{{ $treatment->id }}" selected>{{ $treatment->treatment }}</option>
                        @else
                            <option value="{{ $treatment->id }}">{{ $treatment->treatment }}</option>
                        @endif
                    @endforeach
                </select>
            </div>
            {{-- Filter by branch --}}
            <div class="col-12 col-lg-3 col-xl-2 mb-lg-0">
                <label for="table-branches-filter">{{ __('admin/reports.appointments.columns.branch') }}</label>
                <select name="branches-filter" class="form-control" id="table-branches-filter">
                    <option value="" selected>-</option>
                    @foreach ($branches as $branch)
                        @if ($branch->id == $selected_branch)
                            <option value="{{ $branch->id }}" selected>{{ $branch->branch }}</option>
                        @else
                            <option value="{{ $branch->id }}">{{ $branch->branch }}</option>
                        @endif
                    @endforeach
                </select>
            </div>
            <div class="col-12 col-lg-3 col-xl-2 mb-lg-0">
                <label for="appointment-date-start">{{ __('admin/reports.appointments.columns.appointment_date') }} (start)</label>
                <div class="input-group date" id="appointment-date-start" data-target-input="nearest">
                    <input type="text" name="start-date" class="form-control datetimepicker-input"
                        data-target="#appointment-date-start" value="{{ $selected_start_date }}">
                    <div class="input-group-append" data-target="#appointment-date-start" data-toggle="datetimepicker">
                        <div class="input-group-text"><i class="fas fa-calendar"></i></div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-3 col-xl-2 mb-lg-0">
                <label for="appointment-date-end">{{ __('admin/reports.appointments.columns.appointment_date') }} (end)</label>
                <div class="input-group date" id="appointment-date-end" data-target-input="nearest">
                    <input type="text" name="end-date" class="form-control datetimepicker-input"
                        data-target="#appointment-date-end" value="{{ $selected_end_date }}">
                    <div class="input-group-append" data-target="#appointment-date-end" data-toggle="datetimepicker">
                        <div class="input-group-text"><i class="fas fa-calendar"></i></div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-3 col-xl-2 mb-lg-0 mt-auto">
                <button type="submit" class="btn btn-secondary btn-filter">
                    <i class="fas fa-search"></i>
                </button>
            </div>
        </form>
    </div>

    <x-admin.table.report-table :rows="$result" :columns="$columns" base-link="{{ $route_key }}"
        :action-buttons="['info_modal', 'postpone', 'delete']" />


    <script>
        $(document).ready(function() {

            let max_date = moment('{{$max_date}}', "YYYY-MM-DD").format("YYYY-MM-DD");
            let min_date = moment('{{$min_date}}', "YYYY-MM-DD").format("YYYY-MM-DD");

            $('#appointment-date-start').datepicker({
                format: 'yyyy-mm-dd',
                startDate: min_date,
                endDate: max_date,
                defaultViewDate: min_date,
            });
            $('#appointment-date-end').datepicker({
                format: 'yyyy-mm-dd',
                startDate: min_date,
                endDate: max_date,
                defaultViewDate: max_date,
                
            });
        });
    </script>

@endif
