<div class="table-toolbar col mb-3">
    <div class="row">

        <x-admin.table.search :action="$search_form_action" :keywords="$search" />
        <x-admin.table.rows-per-page :selected="$rows" />
        <x-admin.form.reset-button link="{{ route('admin.appointments') }}" />
        
        <x-admin.form.print-button route-name="admin.appointments"/>
        <x-admin.form.export-button link="{{ route('admin.appointments.export') }}" /> 
        <x-admin.form.add-button title="{{ __('admin/appointments.btn.add') }}"
            link="{{ route('admin.appointments.add') }}" />
        
    </div>
</div>

<x-admin.table.table :rows="$result" :columns="$columns" base-link="{{ $route_key }}" :action-buttons="['info_modal','postpone','delete']"/>

<div id="app-info-card"></div>

<script>
    $(document).ready(function(){

        $('.btn-info-modal').on('click',function(e){

            e.preventDefault();

            let row_id = $(this).attr('data-row-id');

            $.ajax({
                type: "GET",
                url: "{{ route($route_key) }}/info/" + row_id,
                dataType: "html",
                beforeSend: function() {
                    $('#loading-overlay').addClass('is-active');
                },
                error: function(XMLHttpRequest) {
                    alert('error');
                    $('#loading-overlay').removeClass('is-active');
                },
                success: function(data) {
                    $('#app-info-card').html(data);
                    $('#loading-overlay').removeClass('is-active');
                    $('#info-modal').modal('show');
                },
            });

        });
        
    });
</script>
