<?php

namespace App\View\Components\Patient\Form;

use Illuminate\View\Component;

class AddButton extends Component
{
    public $title;
    public $link;
    public $margin;
    public $size;
    public $target; // target_blank

    /**
     * Create a new component instance.
     *
     * @return void
     */
    public function __construct(string $title, string $link, string $margin = 'ml-auto', string $size = 'sm', string $target = '')
    {
        
        $this->title = $title;

        $this->link = $link;

        $this->margin = $margin;

        $this->size = $size;

        if ( $target ){
            $this->target = 'target="_blank"';
        }
        
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        return view('components.patient.form.add-button');
    }
}
