<?php

namespace App\Http\Middleware;

use App\Models\Appointment;
use App\Models\Branch;
use Closure;
use Illuminate\Http\Request;

class AdminFilterRecordsByBranch
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        if ( !is_admin() ) {

            $route_name = $request->route()->getName();

            //======= Appointments
            $routes = ['admin.appointments.postpone','admin.appointments.info','admin.appointments.delete'];

            if ( in_array($route_name,$routes) ) {

                if ( $request->route('appointment_id') ){
                    $appointment = Appointment::find($request->route('appointment_id'));
                }else{
                    $appointment = $request->route('appointment');
                }

                if ( $appointment && !in_array($appointment->branch_id,allowed_branches()) ){
                    abort(404);
                }
            }
            //=======================================================
            $routes = ['admin.branches.edit','admin.branches.delete'];

            if ( in_array($route_name,$routes) ) {

                if ( $request->route('branch_id') ){
                    $branch = Branch::findOrFail($request->route('branch_id'));
                }else{
                    $branch = $request->route('branch');
                }

                if ( $branch && !in_array($branch->id,allowed_branches()) ){
                    abort(404);
                }
            }

            //=======================================================
            $routes = ['admin.complaints.info','admin.complaints.resolved','admin.complaints.download'];

            if ( in_array($route_name,$routes) ) {

              
                $complaint = $request->route('complaint');
                

                if ( $complaint && !in_array($complaint->patient_id,allowed_patients()) ){
                    abort(404);
                }
            }
            
            //=======================================================
            $routes = ['admin.patients.edit','admin.patients.delete'];

            if ( in_array($route_name,$routes) ) {

                $patient = $request->route('patient');
                
                if ( $patient && !in_array($patient->id,allowed_patients()) ){
                    abort(404);
                }
            }
            //=======================================================
            $routes = ['admin.patients.info.index','admin.patients.info.comments'];

            if ( strpos($route_name,'admin.patients.info') >=0 ) {

                $patient = $request->route('patient');
                
                if ( $patient && !in_array($patient->id,allowed_patients()) ){
                    abort(404);
                }
            }
            //=======================================================
            /* $routes = ['admin.pretests.delete'];

            if ( strpos($route_name,'admin.pretests') >=0 ) {

                $patient_pretest = $request->route('patient_pretest');

                $patient = $patient_pretest->patient_id;
                
                if ( $patient && !in_array($patient->id,allowed_patients()) ){
                    abort(404);
                }
            } */
        }

        return $next($request);
    }
}
