<?php

namespace App\Http\Controllers\Patient;

use App\Models\Branch;
use App\Models\SocialAccount;
use Diglactic\Breadcrumbs\Breadcrumbs;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Support\Facades\App;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    /**
     * Render the controller view into the app layout
     *
     * @param string $page
     * @param string $title_lang_key
     * @param string $breadcrumb_name Breadcrumb key string in routes/breadcrumb
     * @param array $breadcrumb_data
     * @param array $data
     * @return void
     */
    protected function loadView($page, $title_lang_key, $breadcrumb_name = null, $breadcrumb_data = null, $data = [], $css = [], $js = [])
    {
        // prep.  data
        $data['_page_title'] = __('patient/' . $title_lang_key);
        
        // breadcrumbs

        /* $data['_breadcrumbs'] = '';
        
        if (!empty($breadcrumb_name)) {
            if (!empty($breadcrumb_data)) {
                $data['_breadcrumbs'] = Breadcrumbs::view('website.app.breadcrumbs', 'patient.' . $breadcrumb_name, $breadcrumb_data);
            } else {

                $data['_breadcrumbs'] = Breadcrumbs::view('website.app.breadcrumbs', 'patient.' . $breadcrumb_name);
            }
        } */

        $data['_page'] = 'patient.' . $page;

        $data['_footer']['social_accounts'] = SocialAccount::get();
        $data['_footer']['branches'] = Branch::get();

        $data['_css'] = $css;
        $data['_js'] = $js;

        App::setLocale('ar');
        
        session()->put('locale', 'ar');      

        echo view('patient.app.app', $data);
    }
}
