<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Appointment;
use App\Models\Review;
use App\Rules\GeneralText;
use Illuminate\Http\Request;
use Laravel\Sanctum\PersonalAccessToken;
use Illuminate\Support\Facades\Validator;

class Reviews extends Controller
{
    public function add(Request $request)
    {
        $user_id = $this->getUserByToken($request);
        //--- if the sent id doesn't match the id from db, 403 forbidden 
        if ($request->input('patient-id') != $user_id) {
            return response()->json(['error' => '403'], 403);
        }

        $appointment = Appointment::findOrFail($request->input('appointment-id'));

        if ( $user_id != $appointment->patient_id){
            return response()->json(['error' => '403'], 403);
        }


        if ($request->getMethod() == 'POST') {

            $rules = [
                'patient-id' => ['required', 'exists:patients,id'],
                'appointment-id' => ['required', 'exists:appointments,id','unique:reviews,appointment_id'],
                'rating' => ['required', 'min:1','max:5'],
                'review' => ['nullable', new GeneralText],
            ];

            $validator = Validator::make($request->all(), $rules,['unique' => 'This treatment has been reviewed already.']);
            
            if ($validator->fails()) {
            
                return response()->json(['error' => $validator->errors()->all()], 400);
            
            }

            // Logical validation
            if ( $appointment->finished_at == null ){
                return response()->json(['error' => 'Error']); 
            }


            $review = [
                'appointment_id' => $request->input('appointment-id'),
                'rating' => $request->input('rating'),
                'review' => $request->input('review'),
            ];

          
            Review::create($review);

            return response()->json(['success' => 'success'],200);
        }
    }
    //==================================================

    private function getUserByToken(Request $request)
    {
        //--- Get the token from request
        $header = $request->header('authorization');

        $token = str_replace('|', '', strstr($header, '|'));

        //--- Get the user id should be using this token
        $hashedToken = hash('sha256', $token);

        $db_token = PersonalAccessToken::where('token', $hashedToken)->first();

        $user = $db_token->tokenable;

        return $user->id;
    }
}
