<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\Controller;
use App\Models\Setting;
use Illuminate\Http\Request;

class SettingsController extends Controller
{
    public function index(Request $request){

        $data['settings'] = Setting::orderBy('group')->get()->groupBy(function($data) {
            return $data->group;
        });

        
        $this->loadView('settings.index','settings.title','settings',[],$data);
    }

    public function save(Request $request){

        $input = $request->all();

        unset($input['_token']);

        foreach ( $input as $key => $value ){

            $setting = [
                'key' => $key,
                'value' => $value
            ];

            Setting::where(['key' => $key])->update($setting);
        }

        return redirect()->route('admin.settings')->with('success',__('admin/common.msgs.success.edit'));
    }
    
}
