<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Admin\Controller;
use App\Models\Patient;
use App\Models\PatientNotification;
use App\Rules\GeneralText;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class NotificationsController extends Controller
{
    public function index()
    {
        $data['patients'] = Patient::allowedPatients()->get();

        $css = ['bs-select/bootstrap-select.min.css'];
        $js = ['bs-select/bootstrap-select.min.js'];

        $this->loadView('notifications.index', 'notifications.title', 'notifications',[],$data,$css,$js);
    }

    public function send(Request $request){

        $validated = $request->validate([
            'title' => ['required','unique:roles,role','min:2','max:200', new GeneralText],
            'body' => ['required',new GeneralText],
            'patients.*' => ['integer', 'exists:patients,id'],
        ]);


        $title = $request->input('title');
        $body = $request->input('body');

        $patients = $validated['patients'];

        $result = notify_patient($title,$body,$patients);

        if ( $result == true ){

            echo 'done';
            //return redirect()->route('admin.notifications')->with('success',__('admin/common.msgs.success.sent'));
        
        }else{

            //return redirect()->route('admin.notifications')->with('error','error');
        
        }
    }


    /* private function sendNotification($data){

        $SERVER_API_KEY = 'AAAAb4-CO_A:APA91bEYiEZby0F8hkvrz30llr8O5vZI_QpUCwu8XmU3UirUHXWj8-2eeWqh1c9yYy5dsatzdcItnm_mkRVQ6rH2Iy6O2b-igUH40vHoZJwDU4W5BSALefXmBJGzWtdQnYeTvVVFOtqq';

        //$SERVER_API_KEY = 'AAAA1vCnGGY:APA91bHJdzUo7Y26LC5NvoYxP1KRA9SyD3AvsWiqrG9-70k2m6lFLqj5lxpu45prdWT6vfHTZEbRwGBVARfwuv6GQtu3GXQzusNeXtWmQb5FFi-FhwQX9IzowTKTa4lj5AghySQB5djH';

        $headers = [

            'Authorization: key=' . $SERVER_API_KEY,

            'Content-Type: application/json',

        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');

        curl_setopt($ch, CURLOPT_POST, true);

        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);

        $response = curl_exec($ch);

        return $response;
    } */
}
