<?php

use Diglactic\Breadcrumbs\Breadcrumbs;

/*
|--------------------------------------------------------------------------
| Admin Breadcrumbs
|--------------------------------------------------------------------------
|
*/

/** Dashboard **/
Breadcrumbs::for('admin.dashboard', function ($trail) {
    $trail->push(__('admin/dashboard.title'), route('admin.dashboard'));
});

/*--------------------------------------------------*/

/** Patients**/
Breadcrumbs::for('admin.patients', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/patients.title'), route('admin.patients'));
});
Breadcrumbs::for('admin.patients.add', function ($trail) {
    $trail->parent('admin.patients');
    $trail->push(__('admin/patients.add_title'), route('admin.patients.add'));
});
Breadcrumbs::for('admin.patients.edit', function ($trail, $patient) {
    $trail->parent('admin.patients');
    $trail->push($patient->getFullName(), route('admin.patients.edit', $patient->id));
});
Breadcrumbs::for('admin.patients.info', function ($trail, $patient) {
    $trail->parent('admin.patients');
    $trail->push($patient->first_name . ' ' . $patient->last_name, route('admin.patients.info', $patient->id));
});
/*--------------------------------------------------*/

/** Regions **/
Breadcrumbs::for('admin.regions', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/regions.title'), route('admin.regions'));
});
Breadcrumbs::for('admin.regions.add', function ($trail) {
    $trail->parent('admin.regions');
    $trail->push(__('admin/regions.add_title'), route('admin.regions.add'));
});
Breadcrumbs::for('admin.regions.edit', function ($trail, $region) {
    $trail->parent('admin.regions');
    $trail->push($region->region, route('admin.regions.add'));
});

/*--------------------------------------------------*/
/** Treatments **/
Breadcrumbs::for('admin.treatments', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/treatments.title'), route('admin.treatments'));
});
Breadcrumbs::for('admin.treatments.add', function ($trail) {
    $trail->parent('admin.treatments');
    $trail->push(__('admin/treatments.add_title'), route('admin.treatments.add'));
});
Breadcrumbs::for('admin.treatments.edit', function ($trail, $treatment) {
    $trail->parent('admin.treatments');
    $trail->push(__('admin/common.buttons.edit') . ': ' . $treatment->treatment, route('admin.treatments.edit', $treatment->id));
});
/*--------------------------------------------------*/
/** Treatment Categories **/
Breadcrumbs::for('admin.treatment_categories', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/treatment_categories.title'), route('admin.treatment_categories'));
});
Breadcrumbs::for('admin.treatment_categories.add', function ($trail) {
    $trail->parent('admin.treatment_categories');
    $trail->push(__('admin/treatment_categories.add_title'), route('admin.treatment_categories.add'));
});
Breadcrumbs::for('admin.treatment_categories.edit', function ($trail, $treatment_category) {
    $trail->parent('admin.treatment_categories');
    $trail->push(__('admin/common.buttons.edit') . ': ' . $treatment_category->name, route('admin.treatment_categories.edit', $treatment_category->id));
});
/*--------------------------------------------------*/
/** Users **/
Breadcrumbs::for('admin.users', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/users.title'), route('admin.users'));
});

Breadcrumbs::for('admin.users.add', function ($trail) {
    $trail->parent('admin.users');
    $trail->push(__('admin/users.add_title'), route('admin.users.add'));
});

Breadcrumbs::for('admin.users.edit', function ($trail, $user) {
    $trail->parent('admin.users');
    $trail->push($user->first_name . ' ' . $user->last_name, route('admin.users.edit', $user->id));
});
/*--------------------------------------------------*/
/** User/Roles **/
Breadcrumbs::for('admin.roles', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/roles.title'), route('admin.roles'));
});
Breadcrumbs::for('admin.roles.add', function ($trail) {
    $trail->parent('admin.roles');
    $trail->push(__('admin/roles.add_title'), route('admin.roles.add'));
});
Breadcrumbs::for('admin.roles.edit', function ($trail, $role) {
    $trail->parent('admin.roles');
    $trail->push(__('admin/common.buttons.edit') . ': ' . $role->role, route('admin.roles.edit', $role->id));
});
/*--------------------------------------------------*/
/** Appointments **/
Breadcrumbs::for('admin.appointments', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/appointments.title'), route('admin.appointments'));
});
Breadcrumbs::for('admin.appointments.add', function ($trail) {
    $trail->parent('admin.appointments');
    $trail->push(__('admin/appointments.add_title'), route('admin.appointments.add'));
});
Breadcrumbs::for('admin.appointments.postpone', function ($trail, $appointment) {
    $trail->parent('admin.appointments');
    $trail->push(__('admin/appointments.postpone_title'), route('admin.appointments.postpone', $appointment));
});
/*--------------------------------------------------*/
/** Side Effects **/
Breadcrumbs::for('admin.complaints', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/complaints.title'), route('admin.complaints'));
});
Breadcrumbs::for('admin.complaints.add', function ($trail) {
    $trail->parent('admin.complaints');
    $trail->push(__('admin/complaints.add_title'), route('admin.complaints.add'));
});
Breadcrumbs::for('admin.complaints.info', function ($trail, $complaint) {
    $trail->parent('admin.complaints');
    $trail->push($complaint->patient->getFullName(), route('admin.complaints.info', $complaint->id));
});
/*--------------------------------------------------*/
/** Branches **/
Breadcrumbs::for('admin.branches', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/branches.title'), route('admin.branches'));
});
Breadcrumbs::for('admin.branches.add', function ($trail) {
    $trail->parent('admin.branches');
    $trail->push(__('admin/branches.add_title'), route('admin.branches.add'));
});
Breadcrumbs::for('admin.branches.edit', function ($trail, $branch) {
    $trail->parent('admin.branches');
    $trail->push($branch->branch, route('admin.branches.edit', $branch->id));
});

/*--------------------------------------------------*/
/** Pretest **/
Breadcrumbs::for('admin.pretests', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/pretests.title'), route('admin.pretests'));
});
Breadcrumbs::for('admin.pretests.add', function ($trail) {
    $trail->parent('admin.pretests');
    $trail->push(__('admin/pretests.add_title'), route('admin.pretests.add'));
});
Breadcrumbs::for('admin.pretests.edit', function ($trail, $patient_pretest) {
    $trail->parent('admin.pretests');
    $trail->push($patient_pretest->title, route('admin.pretests.edit', $patient_pretest->id));
});
Breadcrumbs::for('admin.pretests.info', function ($trail, $pretest) {
    $trail->parent('admin.pretests');
    $trail->push($pretest->title, route('admin.pretests.info', $pretest->id));
});
/*--------------------------------------------------*/
/** Notifications **/
Breadcrumbs::for('admin.notifications', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/notifications.title'), route('admin.notifications'));
});

/*--------------------------------------------------*/
/** Notifications **/
Breadcrumbs::for('admin.reviews', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/reviews.title'), route('admin.reviews'));
});

Breadcrumbs::for('admin.reviews.info', function ($trail, $review) {
    $trail->parent('admin.reviews');
    $trail->push($review->id, route('admin.reviews.info', $review->id));
});

/*--------------------------------------------------*/
/** Admin Website **/
Breadcrumbs::for('admin.website.home', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/website.home.title'), route('admin.website.home'));
});

Breadcrumbs::for('admin.website.about', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/website.about.title'), route('admin.website.about'));
});

Breadcrumbs::for('admin.website.treatments', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/website.treatments.title'), route('admin.website.treatments'));
});

Breadcrumbs::for('admin.social_accounts', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/social_accounts.title'), route('admin.social_accounts'));
});

Breadcrumbs::for('admin.social_accounts.add', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/social_accounts.add_title'), route('admin.social_accounts.add'));
});

Breadcrumbs::for('admin.social_accounts.edit', function ($trail,$social_account) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/social_accounts.edit_title'), route('admin.social_accounts.edit',$social_account));
});
/*--------------------------------------------------*/
/*************
 * Offers
 *************/
Breadcrumbs::for('admin.offers', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/offers.title'), route('admin.offers'));
});

Breadcrumbs::for('admin.offers.add', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/offers.add_title'), route('admin.offers.add'));
});

Breadcrumbs::for('admin.offers.edit', function ($trail,$offer) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/offers.edit_title'), route('admin.offers.edit',$offer));
});


Breadcrumbs::for('admin.settings', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/settings.title'));
});
/*--------------------------------------------------*/
Breadcrumbs::for('admin.reports.patient_history', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/reports.patient_history.title'));
});
Breadcrumbs::for('admin.reports.booked_appointments', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/reports.booked_appointments.title'));
});
Breadcrumbs::for('admin.reports.user_activity', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/reports.user_activity.title'));
});
Breadcrumbs::for('admin.reports.appointments', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/reports.appointments.title'));
});

/*--------------------------------------------------*/
Breadcrumbs::for('admin.mail.inbox', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/mail.inbox.title'));
});

/*--------------------------------------------------*/
Breadcrumbs::for('admin.profile', function ($trail) {
    $trail->parent('admin.dashboard');
    $trail->push(__('admin/profile.title'));
});



/* Breadcrumbs::for('admin.appointments.recycle_bin', function ($trail) {
    $trail->parent('admin.appointments');
    $trail->push(__('admin/appointments.recycle_bin_title'), route('admin.appointments.recycle_bin'));
}); */
//====================================================


/*
|--------------------------------------------------------------------------
| Patient Breadcrumbs
|--------------------------------------------------------------------------
|
*/

/** Patient**/

Breadcrumbs::for('patient.dashboard', function ($trail) {
    $trail->parent('patient.home');
    $trail->push(__('patient/dashboard.title'), route('patient.dashboard'));
});


Breadcrumbs::for('patient.login', function ($trail) {
    $trail->parent('patient.home');
    $trail->push(__('patient/login.title'), route('patient.login'));
});

Breadcrumbs::for('patient.register', function ($trail) {
    $trail->parent('patient.home');
    $trail->push(__('patient/register.title'), route('patient.register'));
});

Breadcrumbs::for('patient.verify', function ($trail) {
    $trail->parent('patient.home');
    $trail->push(__('patient/verify.title'), route('patient.verify'));
});

Breadcrumbs::for('patient.forgot', function ($trail) {
    $trail->parent('patient.home');
    $trail->push(__('patient/forgot.title'), route('patient.forgot'));
});

Breadcrumbs::for('patient.appointments', function ($trail) {
    $trail->parent('patient.home');
    $trail->push(__('patient/appointments.title'), route('patient.appointments'));
});
Breadcrumbs::for('patient.appointments.add', function ($trail) {
    $trail->parent('patient.appointments');
    $trail->push(__('patient/appointments.add.title'), route('patient.appointments.add'));
});
Breadcrumbs::for('patient.appointments.edit', function ($trail, $appointment) {
    $trail->parent('patient.appointments');
    $trail->push($appointment->appointment_date, route('patient.appointments.edit', $appointment->id));
});

Breadcrumbs::for('patient.complaints', function ($trail) {
    $trail->parent('patient.home');
    $trail->push(__('patient/appointments.title'), route('patient.complaints'));
});
Breadcrumbs::for('patient.complaints.add', function ($trail) {
    $trail->parent('patient.complaints');
    $trail->push(__('patient/complaints.add.title'), route('patient.complaints.add'));
});



