<div class="row mt-4">
    <div class="col-12">
        @if ($info)
            <div class="alert alert-info" role="alert">
                <span>{{ $info }}</span>
            </div>
        @endif
    </div>
</div>
@include('pretests.patient_info')
<div class="row">
    <div class="col-12 col-lg-6 col-xl-4">
        <label for="session-date" class="form-label required">{{ __('pretests.laser_sessions.date') }}</label>
        <div class="input-group date" id="session-date" data-target-input="nearest">
            <input type="text" name="session-date" class="form-control datetimepicker-input" data-target="#session-date" value="{{ $answers['session-date'] }}">
            <div class="input-group-append" data-target="#session-date" data-toggle="datetimepicker">
                <div class="input-group-text"><i class="fas fa-calendar"></i></div>
            </div>
        </div>
    </div>
    <div class="col-12 col-lg-6 col-xl-4">
        <label for="session-type" class="form-label required">
            {{ __('pretests.laser_sessions.session_type') }}
        </label>
        <select name="session-type" id="session-type" class="form-control">
            <option value="s" @if($answers['session-type'] == 's') selected @endif >{{ __('pretests.laser_sessions.types.control') }}</option>
            <option value="c" @if($answers['session-type'] == 'c') selected @endif>{{ __('pretests.laser_sessions.types.session') }}</option>
        </select>
    </div>
    <div class="col-12 col-lg-6 col-xl-4">
        <label for="session-type" class="form-label required">
            {{ __('pretests.laser_sessions.session_number') }}
        </label>
        <input type="text" name="session-number" class="form-control" value="{{ $answers['session-number'] }}">
    </div>
</div>
<div class="row mt-5">
    <div class="col-12">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>{{ __('pretests.laser_sessions.location') }}</th>
                    <th>{{ __('pretests.laser_sessions.spot_size') }}</th>
                    <th>{{ __('pretests.laser_sessions.pulse') }}</th>
                    <th>{{ __('pretests.laser_sessions.e') }}</th>
                    <th>{{ __('pretests.laser_sessions.hair') }}</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                        <label>{{ __('pretests.laser_sessions.locations.body') }}</label>
                    </td>
                    <td>
                        <input type="text" name="body-spot-size" class="form-control" value="{{ $answers['body-spot-size'] }}">
                    </td>
                    <td>
                        <input type="text" name="body-pulse" class="form-control" value="{{ $answers['body-pulse'] }}">
                    </td>
                    <td>
                        <input type="text" name="body-e" class="form-control" value="{{ $answers['body-e'] }}">
                    </td>
                    <td>
                        <input type="text" name="body-hair" class="form-control" value="{{ $answers['body-hair'] }}">
                    </td>
                </tr>
                <tr>
                    <td>
                        <label>{{ __('pretests.laser_sessions.locations.face') }}</label>
                    </td>
                    <td>
                        <input type="text" name="face-spot-size" class="form-control" value="{{ $answers['face-spot-size'] }}">
                    </td>
                    <td>
                        <input type="text" name="face-pulse" class="form-control" value="{{ $answers['face-pulse'] }}">
                    </td>
                    <td>
                        <input type="text" name="face-e" class="form-control" value="{{ $answers['face-e'] }}">
                    </td>
                    <td>
                        <input type="text" name="face-hair" class="form-control" value="{{ $answers['face-hair'] }}">
                    </td>
                </tr>
                <tr>
                    <td>
                        <label>{{ __('pretests.laser_sessions.locations.sens') }}</label>
                    </td>
                    <td>
                        <input type="text" name="sens-spot-size" class="form-control" value="{{ $answers['sens-spot-size'] }}">
                    </td>
                    <td>
                        <input type="text" name="sens-pulse" class="form-control" value="{{ $answers['sens-pulse'] }}">
                    </td>
                    <td>
                        <input type="text" name="sens-e" class="form-control" value="{{ $answers['sens-e'] }}">
                    </td>
                    <td>
                        <input type="text" name="sens-hair" class="form-control" value="{{ $answers['sens-hair'] }}">
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    @if( array_key_exists('notes',$answers))
        <div class="form-group mb-4 col-12">
            <label for="notes" class="form-label font-weight-bold">{{ __('pretests.notes') }}</label><br>
            <textarea name="notes" class="form-control" id="notes" rows="5">{{ $answers['notes'] }}</textarea>
        </div>
    @endif
    @if( array_key_exists('attachment',$answers))
    <div class="form-group col-12 mb-4">
        <span class="font-weight-bold my-auto ml-auto mr-3">
            {{ __('admin/complaints.form.attachment') }}
        </span>
        <a href="{{ route('admin.pretests.download',[ $patient->id, $answers['attachment'] ] ) }}" class="btn btn-sm btn-info"
            target="_blank">
            <i class="fas fa-file-download"></i>
        </a>
    </div>
    @endif
    <div class="form-group mb-4 col-12">
        <label for="pretest-attachment" class="form-label font-weight-bold">
            {{ __('admin/complaints.form.attachment') }}
            <small class="text-muted">(5 MB maximum)</small>
        </label>
        <div class="input-group">
            <div class="custom-file">
                <input type="file" name="attachment" class="custom-file-input" id="pretest-attachment"aria-describedby="pretest-attachment">
                <label class="custom-file-label " for="pretest-attachment">
                    {{ __('admin/complaints.form.browse') }}
                </label>
            </div>
        </div>
    </div>
    <x-admin.form.save-button title="{{ __('admin/common.buttons.save') }}" />
</div>
