<div class="row mt-4">
    <div class="col-12">
        @if ($info)
            <div class="alert alert-info" role="alert">
                <span>{{ $info }}</span>
            </div>
        @endif
    </div>
</div>
@include('pretests.patient_info')
<div class="row">
    <div class="col-12 col-lg-6 col-xl-4">
        <label for="session-date" class="form-label required">{{ __('pretests.laser_sessions.date') }}</label>
        <div class="input-group date" id="session-date" data-target-input="nearest">
            <input type="text" name="session-date" class="form-control datetimepicker-input" data-target="#session-date" value="{{ date('Y-m-d') }}">
            <div class="input-group-append" data-target="#session-date" data-toggle="datetimepicker">
                <div class="input-group-text"><i class="fas fa-calendar"></i></div>
            </div>
        </div>
    </div>
    <div class="col-12 col-lg-6 col-xl-4">
        <label for="session-type" class="form-label required">
            {{ __('pretests.laser_sessions.session_type') }}
        </label>
        <select name="session-type" id="session-type" class="form-control">
            <option value="s">{{ __('pretests.laser_sessions.types.control') }}</option>
            <option value="c">{{ __('pretests.laser_sessions.types.session') }}</option>
        </select>
    </div>
    <div class="col-12 col-lg-6 col-xl-4">
        <label for="session-type" class="form-label required">
            {{ __('pretests.laser_sessions.session_number') }}
        </label>
        <input type="text" name="session-number" class="form-control" value="">
    </div>
</div>
<div class="row mt-5">
    <div class="col-12">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>{{ __('pretests.laser_sessions.location') }}</th>
                    <th>{{ __('pretests.laser_sessions.spot_size') }}</th>
                    <th>{{ __('pretests.laser_sessions.pulse') }}</th>
                    <th>{{ __('pretests.laser_sessions.e') }}</th>
                    <th>{{ __('pretests.laser_sessions.hair') }}</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                        <label>{{ __('pretests.laser_sessions.locations.body') }}</label>
                    </td>
                    <td>
                        <input type="text" name="body-spot-size" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="body-pulse" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="body-e" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="body-hair" class="form-control">
                    </td>
                </tr>
                <tr>
                    <td>
                        <label>{{ __('pretests.laser_sessions.locations.face') }}</label>
                    </td>
                    <td>
                        <input type="text" name="face-spot-size" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="face-pulse" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="face-e" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="face-hair" class="form-control">
                    </td>
                </tr>
                <tr>
                    <td>
                        <label>{{ __('pretests.laser_sessions.locations.sens') }}</label>
                    </td>
                    <td>
                        <input type="text" name="sens-spot-size" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="sens-pulse" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="sens-e" class="form-control">
                    </td>
                    <td>
                        <input type="text" name="sens-hair" class="form-control">
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="form-group mb-4 col-12">
        <label for="pretest-attachment" class="form-label font-weight-bold">
            {{ __('admin/complaints.form.attachment') }}
            <small class="text-muted">(5 MB maximum)</small>
        </label>
        <div class="input-group">
            <div class="custom-file">
                <input type="file" name="attachment" class="custom-file-input" id="pretest-attachment"aria-describedby="pretest-attachment">
                <label class="custom-file-label " for="pretest-attachment">
                    {{ __('admin/complaints.form.browse') }}
                </label>
            </div>
        </div>
    </div>
    <div class="form-group mb-4 col-12">
        <label for="notes" class="form-label font-weight-bold">{{ __('pretests.notes') }}</label><br>
        <textarea name="notes" class="form-control" id="notes" rows="5"></textarea>
    </div>
    <x-admin.form.save-button title="{{ __('admin/common.buttons.save') }}" />
</div>
