<div class="row mt-4">
    <div class="col-12">
        @if ($info)
            <div class="alert alert-info" role="alert">
                <span>{{ $info }}</span>
            </div>
        @endif
    </div>
</div>
@include('pretests.patient_info')
<div class="container-fluid mt-3">
    <div class="row">
        <div class="col-12 col-md-6 col-lg-4 col-xl-3 mb-3">
            <label for="session-date" class="form-label required">{{ __('pretests.fractional_session.session-date') }}</label>
            <div class="input-group date" id="session-date" data-target-input="nearest">
                <input type="text" name="session-date" class="form-control datetimepicker-input" data-target="#session-date"
                    value="{{ $patient_pretest->form_date }}">
                <div class="input-group-append" data-target="#session-date" data-toggle="datetimepicker">
                    <div class="input-group-text"><i class="fas fa-calendar"></i></div>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-6 col-lg-4 col-xl-3 mb-3">
            <label for="session-type" class="form-label required">
                {{ __('pretests.fractional_session.session-number') }}
            </label>
            <input type="text" name="session-number" class="form-control" value="{{ $answers['session-number'] }}">
        </div>
        <div class="col-12 col-md-6 col-lg-4 col-xl-3 mb-3">
            <label for="session-type" class="form-label required">
                {{ __('pretests.fractional_session.physician') }}
            </label><br>
            <label class="form-control-plaintext">{{ user_name() }}</label>
            <input type="hidden" name="physician" value="{{ user_name() }}">
        </div>
    </div>
    <div class="row mt-4">
        <div class="col-12 col-md-6 col-lg-4 col-xl-3 mb-3">
            <label class="form-label required">
                {{ __('pretests.fractional_session.light') }}
            </label>
            <input type="text" name="light" class="form-control" value="{{ $answers['light'] }}">
        </div>
        <div class="col-12 col-md-6 col-lg-4 col-xl-3 mb-3">
            <label class="form-label required">
                {{ __('pretests.fractional_session.mid') }}
            </label>
            <input type="text" name="mid" class="form-control" value="{{ $answers['mid'] }}">
        </div>
        <div class="col-12 col-md-6 col-lg-4 col-xl-3 mb-3">
            <label class="form-label required">
                {{ __('pretests.fractional_session.deep') }}
            </label>
            <input type="text" name="deep" class="form-control" value="{{ $answers['deep'] }}">
        </div>
        <div class="col-12 col-md-6 col-lg-4 col-xl-3 mb-3">
            <label class="form-label required">
                {{ __('pretests.fractional_session.note') }}
            </label>
            <input type="text" name="note" class="form-control" value="{{ $answers['note'] }}">
        </div>
    </div>
    @if( array_key_exists('attachment',$answers))
    <div class="form-group col-12 mb-4">
        <span class="font-weight-bold my-auto ml-auto mr-3">
            {{ __('admin/complaints.form.attachment') }}
        </span>
        <a href="{{ route('admin.pretests.download',[ $patient->id, $answers['attachment'] ] ) }}" class="btn btn-sm btn-info"
            target="_blank">
            <i class="fas fa-file-download"></i>
        </a>
    </div>
    @endif
    <div class="form-group mb-4 col-12">
        <label for="pretest-attachment" class="form-label font-weight-bold">
            {{ __('admin/complaints.form.attachment') }}
            <small class="text-muted">(5 MB maximum)</small>
        </label>
        <div class="input-group">
            <div class="custom-file">
                <input type="file" name="attachment" class="custom-file-input" id="pretest-attachment"aria-describedby="pretest-attachment">
                <label class="custom-file-label " for="pretest-attachment">
                    {{ __('admin/complaints.form.browse') }}
                </label>
            </div>
        </div>
    </div>
    <div class="d-flex w-100">
        <x-admin.form.save-button title="{{ __('admin/common.buttons.save') }}" />
    </div>
</div>
