<div class="col-12 d-flex mb-4 align-items-center">
    @if ($prev_week)
        <div class="me-5">
            <button type="button" id="previous-week" data-href="{{ $prev_week }}"
                class="calendar-nav btn btn-secondary btn-sm">
                @if (app()->getLocale() == 'ar')
                    <i class="fas fa-chevron-right"></i>
                @else
                    <i class="fas fa-chevron-left"></i>
                @endif
                {{ __('patient/appointments.btn.prev_week') }}
            </button>
        </div>
    @endif
    <span class="h3 mx-auto"> {{ $date_range_title }}</span>
    @if ($next_week)
        <div class="ms-5">
            <button type="button" id="next-week" data-href="{{ $next_week }}"
                class="calendar-nav btn btn-secondary btn-sm">
                {{ __('patient/appointments.btn.next_week') }}
                @if (app()->getLocale() == 'ar')
                    <i class="fas fa-chevron-left"></i>
                @else
                    <i class="fas fa-chevron-right"></i>
                @endif
            </button>
        </div>
    @endif
</div>
<div class="col-auto ms-auto mb-3">
    <a href="{{ route('patient.appointments') }}" class="btn btn-secondary">
        <i class="fas fa-undo"></i>
        {{ __('patient/appointments.btn.back') }}
    </a>
    <button type="submit" class="btn btn-gold px-5" title="{{ __('patient/common.buttons.save') }}">
        {{ __('patient/common.buttons.save') }}
    </button>
</div>
<div class="col-12">
    @if ($calendar)
        <input type="hidden" id="ap-date" name="ap-date" value="{{ $selected_date }}">
        <input type="hidden" id="ap-session" name="ap-session" value="{{ $selected_time }}">
        @foreach ($calendar as $day)
            @if (!empty(array_filter($day['sessions'])))
                <div class="card mb-3 w-100 bg-dark-75">
                    <div class="row no-gutters">
                        <div class="col-auto my-auto text-center px-5">
                            <h5>{{ $day['day'] }}</h5>
                            <span>{{ $day['date'] }}</span>
                        </div>
                        <div class="col">
                            <div class="card-body">
                                <div class="row d-flex justify-content-start">
                                    @foreach ($day['sessions'] as $session)
                                        @php $rand = rand(0, 9999); @endphp
                                        {{-- <div class="col-2 col-xl-1 mb-3 text-center"> --}}
                                            <div class="sam-custom-radio d-flex w-auto mb-2">
                                                <input type="radio" id="appointment-{{ $rand }}"
                                                    name="appointment" data-date="{{ $day['date'] }}"
                                                    data-session="{{ $session }}" @if ($selected_date == $day['date'] && $selected_time == $session) checked="checked" @endif>
                                                <label for="appointment-{{ $rand }}">{{ $session }}</label>
                                            </div>
                                        {{-- </div> --}}
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endif
        @endforeach
    @endif
</div>
<div class="d-grid col-6 mx-auto">
    <button type="submit" class="btn btn-gold btn-lg" title="{{ __('patient/common.buttons.save') }}">
        {{ __('patient/common.buttons.save') }}
    </button>
</div>
<script>
    $(document).ready(function() {

        $(document).off("click").on('click', '.calendar-nav', function(e) {

            e.preventDefault();

            let href = $(this).attr('data-href');

            $.ajax({
                type: "GET",
                url: href,
                dataType: "html",
                beforeSend: function() {
                    $('#loading-overlay').addClass('is-active');
                },
                error: function(XMLHttpRequest) {
                    alert('error');
                    $('#loading-overlay').removeClass('is-active');
                },
                success: function(data) {
                    $('#sessions-table').html(data);
                    $('#loading-overlay').removeClass('is-active');
                },
            });
        });
        $(document).on('click', 'input[name="appointment"]', function(e) {

            if ($(this).is(':checked')) {

                $('#ap-week').val($(this).attr('data-week'));
                $('#ap-date').val($(this).attr('data-date'));
                $('#ap-session').val($(this).attr('data-session'));
            }
        });
        $(document).on('submit', '#add-appointment-form', function(e) {

            e.preventDefault();

            let form = $(this);
            let formData = new FormData(form[0]);
            formData.append('patient',"{{ patient_id() }}")
            let url = form.attr('action');

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                error: function(xhr) {
                    
                    let parsed = JSON.parse(xhr.responseText);

                    console.log(parsed);

                    $('#error-alerts').remove();

                    let html = '<div id="error-alerts" class="col-12">';
                    html +=
                        '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
                    //$.each(parsed.error, function(key, err) {
                        html += '<span>' + parsed.error + '</span></br>';
                    //});
                    html +=
                        '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>';
                    html += '</div>';
                    html += '</div>';

                    $('#page-alerts').prepend(html);
                }
            });
            $.ajax({
                type: "POST",
                url: url,
                data: formData,
                dataType: 'json',
                contentType: false,
                processData: false,
                cache: false,
                success: function(data) {
                    console.log(data);
                    if (data.success) {
                        window.location.href = "{{ route('patient.appointments') }}";
                    }
                }
            });
            return false;
        });
    });
</script>
