<div class="col-12 mt-4">
    <table class="table table-bordered border-secondary">
        <thead class="text-light fw-normal">
            <tr>
                <th class="fit text-center fw-normal">#</th>
                @foreach ($columns as $col)
                    {!! $col !!}
                @endforeach
                <th class="text-center fw-normal">{{ __('admin/common.cols.actions') }}</th>
            </tr>
        </thead>
        <tbody class="text-light fw-light">
            @if ($rows)
                @foreach ($rows as $index => $row)
                    <tr>
                        <td class="text-center">{{ $first_index++ }}</td>
                        @foreach ($columns as $key => $col)
                            <td>{{ $row[$key] }}</td>
                        @endforeach
                        <td class="fit text-right">
                            @if ($groupButtons)
                                <div class="dropdown">
                                    <button class="btn btn-secondary dropdown-toggle" type="button"
                                        id="action-bittons-dropdown" data-toggle="dropdown" aria-haspopup="true"
                                        aria-expanded="false">
                                        <i class="fas fa-ellipsis-v"></i>
                                    </button>
                                    <div class="dropdown-menu" aria-labelledby="action-bittons-dropdown">
                                        @foreach ($actionButtons as $button)
                                            <a class="dropdown-item" href="#">
                                                @switch($button)
                                                    @case('info')
                                                        <x-admin.form.info-button link="{{ route($baseLink) }}"
                                                            id="{{ $row['id'] }}" />
                                                    @break
                                                    @case('edit')
                                                        <x-admin.form.edit-button link="{{ route($baseLink) }}"
                                                            id="{{ $row['id'] }}" />
                                                    @break
                                                    @case('delete')
                                                        <x-admin.form.delete-button link="{{ route($baseLink) }}"
                                                            id="{{ $row['id'] }}" />
                                                    @break
                                                    @case('info_modal')
                                                        <x-admin.form.info-modal-button id="{{ $row['id'] }}" />
                                                    @break
                                                    @case('check_in')
                                                        <x-admin.form.check-in-button link="{{ route($baseLink) }}"
                                                            id="{{ $row['id'] }}" />
                                                    @break
                                                    @case('postpone')
                                                        <x-admin.form.postpone-button link="{{ route($baseLink) }}"
                                                            id="{{ $row['id'] }}" />
                                                    @break
                                                    @default
                                                @endswitch
                                            </a>
                                        @endforeach
                                    </div>
                                </div>
                            @else
                                @foreach ($actionButtons as $button)
                                    @switch($button)
                                        @case('info')
                                            <x-admin.form.info-button link="{{ route($baseLink) }}"
                                                id="{{ $row['id'] }}" />
                                        @break
                                        @case('edit')
                                            <x-admin.form.edit-button link="{{ route($baseLink) }}"
                                                id="{{ $row['id'] }}" />
                                        @break
                                        @case('delete')
                                            <x-admin.form.delete-button link="{{ route($baseLink) }}"
                                                id="{{ $row['id'] }}" />
                                        @break
                                        @case('info_modal')
                                            <x-admin.form.info-modal-button id="{{ $row['id'] }}" />
                                        @break
                                        @case('check_in')
                                            <x-admin.form.check-in-button link="{{ route($baseLink) }}"
                                                id="{{ $row['id'] }}" />
                                        @break
                                        @case('postpone')
                                            <x-admin.form.postpone-button link="{{ route($baseLink) }}"
                                                id="{{ $row['id'] }}" />
                                        @break
                                        @default
                                    @endswitch
                                @endforeach
                            @endif
                        </td>
                    </tr>
                @endforeach
            @else
                <tr>
                    <td colspan="{{ count($columns) + 2 }}" class="text-center">
                        {{ __('admin/common.msgs.no_results') }}
                    </td>
                </tr>
            @endif
        </tbody>
    </table>
    @if ($rows)
        <div class="row mt-3 pb-5">
            <div class="col-12 col-lg-auto my-auto">
                <span class="font-italic text-sm">
                    {{ $pagination['msg'] }}
                </span>
            </div>
            <div class="col-12 col-lg-auto ml-auto">
                {{ $pagination['links'] }}
            </div>
        </div>
    @endif
    <script>
        $(document).ready(function() {

            $('.btn-filter').on('click', function(e) {

                //let url = window.location.href.split('?')[0];
                let url = '{{ route($baseLink) }}';

                // get rows
                let rows = $('#table-rows-per-page').val();

                if (rows) {
                    url += '?rows=' + rows;
                }

                //get filters
                let filter = $('#table-row-filters').val();

                if (filter) {
                    url += '&filter=' + filter;
                }

                //get search
                let search = $('#table-search').val();

                if (search) {
                    url += '&search=' + search;
                }

                // get sort by
                let sort = $('table th[sorted]').first().attr('data-sort');

                if (sort) {
                    url += '&sort=' + sort;
                }

                // get order by
                let order = $('table th[sorted]').first().attr('data-order');

                if (order) {
                    url += '&order=' + order;
                }

                window.location.href = url;
            });

        });
    </script>
</div>
