<div class="row mb-5">
    <div class="col-12 d-flex">
        <form action="{{ route('admin.reports.get_patient_history') }}" method="POST" class="w-100"
            enctype="multipart/form-data">
            @csrf
            <select name="patient" class="selectpicker" data-live-search="true" selectpicker>
                @foreach ($patients as $patient)
                    <option value="{{ $patient->id }}" data-subtext="{{ $patient->mobile }}" @if($selected_patient == $patient->id) selected @endif>
                        {{ $patient->full_name }}
                    </option>
                @endforeach
            </select>
            <button type="submit" class="btn btn-secondary ml-5 btn-sm">
                {{ __('admin/common.buttons.display') }}
            </button>
        </form>
    </div>
</div>
@if ( $result )
<div class="table-toolbar col mb-3">
    <div class="row">
        <x-admin.table.search :action="$search_form_action" :keywords="$search" />
        <x-admin.table.rows-per-page :selected="$rows" />
        <x-admin.form.reset-button link="{{ route('admin.appointments') }}" />
        <div class="dropdown ml-auto px-3">
            <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="print-dropdown-menu" data-toggle="dropdown" aria-expanded="false">
              <i class="fas fa-print"></i>
            </button>
            <div class="dropdown-menu dropdown-menu-right" aria-labelledby="print-dropdown-menu">
                <a class="dropdown-item" target="_blank" href="{{ $print_all }}">All Records</a>
                <a class="dropdown-item" target="_blank" href="{{ $print_current }}">Current Selection</a>
            </div>
        </div>
    </div>
</div>

<x-admin.table.report-table :rows="$result" :columns="$columns" base-link="{{ $route_key }}" :action-buttons="['info_modal','postpone','delete']"/>

@endif

