<div class="col-12">
    <div class="card bg-white p-3">
        <form action="{{ route('admin.profile.save') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-group row mb-3">
                <div class="col-12 col-md-10 col-lg-8 col-xxl-6">
                    <label for="password" class="form-label required">
                        {{ __('admin/profile.password') }}
                    </label>
                    <div class="input-group mb-3">
                        <input type="password" name="password" id="password" class="form-control"
                            data-visibile="false" aria-describedby="toggle-password">
                        <button class="btn btn-light" type="button" id="toggle-password">
                            <i class="far fa-eye-slash"></i>
                        </button>
                    </div>
                    <small id="password-helper" class="form-text text-muted">A-Z,a-z,-0-9,char and minimum of 8</small>
                    <label id="pass-suggestion" class="mt-3 text-info">
                        {{ __('admin/patients.form.suggestion') }}
                        <span class="bg-light">{{ $gen_password }}</span>
                    </label>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-md-10 col-lg-8 col-xxl-6 ml-auto">
                    <x-admin.form.save-button />
                </div>
            </div>
        </form>
    </div>
    <script>
        $(document).ready(function() {
            $('#toggle-password').on('click', function(e) {

                e.preventDefault();

                let pass_field = $('#password');

                if (pass_field.data('visibile') == 'true') {
                    pass_field.data('visibile', 'false');
                    pass_field.attr('type', 'password');
                    $(this).html('<i class="far fa-eye-slash"></i>');
                } else {
                    pass_field.data('visibile', 'true');
                    pass_field.attr('type', 'text');
                    $(this).html('<i class="far fa-eye"></i>');

                }

            });

            $('#pass-suggestion').on('click', function() {

                let pass = $('#pass-suggestion > span').html();

                $('#password').val(pass);

            });
        });
    </script>
</div>
