<div class=" col-12">
    <div class="card bg-white p-3">
        <form action="{{ route('admin.patients.update', $patient->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="col">
                    <h4>{{ __('admin/patients.form.patient_info') }}</h4>
                    <hr>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-md-6 col-lg-3">
                    <label for="add-first-name"
                        class="col-form-label required">{{ __('admin/patients.form.first_name') }}</label>
                    <input type="text" name="first-name" class="form-control" id="add-first-name"
                        value="{{ old('first-name', $patient->first_name) }}">
                </div>
                <div class="col-12 col-md-6 col-lg-3">
                    <label for="add-second-name"
                        class="col-form-label">{{ __('admin/patients.form.second_name') }}</label>
                    <input type="text" name="second-name" class="form-control" id="add-second-name"
                        value="{{ old('second-name', $patient->second_name) }}">
                </div>
                <div class="col-12 col-md-6 col-lg-3">
                    <label for="add-third-name"
                        class="col-form-label">{{ __('admin/patients.form.third_name') }}</label>
                    <input type="text" name="third-name" class="form-control" id="add-third-name"
                        value="{{ old('third-name', $patient->third_name) }}">
                </div>
                <div class="col-12 col-md-6 col-lg-3">
                    <label for="add-last-name"
                        class="col-form-label required">{{ __('admin/patients.form.last_name') }}</label>
                    <input type="text" name="last-name" class="form-control" id="add-last-name"
                        value="{{ old('last-name', $patient->last_name) }}">
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-md-6 col-lg-4 col-xl-3">
                    <label for="add-dob" class="col-form-label required">{{ __('admin/patients.form.dob') }}</label>
                    <div class="input-group date" id="add-dob" data-target-input="nearest">
                        <input type="text" name="dob" class="form-control datetimepicker-input"
                            data-target="#add-dob" value="{{ old('dob', $patient->formatted_dob) }}" />
                        <div class="input-group-append" data-target="#add-dob" data-toggle="datetimepicker">
                            <div class="input-group-text"><i class="fas fa-calendar"></i></div>
                        </div>
                    </div>
                </div>
                <div class="col-12 col-md-6 col-lg-4 col-xl-3">
                    <label for="add-gender" class="col-form-label required">
                        {{ __('admin/patients.form.gender') }}
                    </label>
                    <select name="gender" class="form-control" id="add-gender">
                        <option value="m" {{ old('gender', $patient->gender) == 'm' ? 'selected' : '' }}>
                            {{ __('admin/common.gender.male') }}
                        </option>
                        <option value="f" {{ old('gender', $patient->gender) == 'f' ? 'selected' : '' }}>
                            {{ __('admin/common.gender.female') }}
                        </option>
                    </select>
                </div>
                <div class="col-12 col-md-6 col-lg-4 col-xl-3">
                    <label for="add-mobile" class="col-form-label required">
                        {{ __('admin/patients.form.mobile') }}
                        <small class="muted">(05xxxxxxx)</small>
                    </label>
                    <input type="text" name="mobile" class="form-control" id="add-mobile"
                        value="{{ old('mobile', $patient->mobile) }}">
                </div>
                <div class="col-12 col-md-6 col-lg-4 col-xl-3">
                    <label for="add-email"
                        class="col-form-label">{{ __('admin/patients.form.email') }}</label>
                    <input type="text" name="email" class="form-control" id="add-email"
                        value="{{ old('email', $patient->email) }}">
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-12 col-lg-6 py-0">
                    <div class="w-100 mb-3">
                        <label for="add-region"
                            class="col-form-label required">{{ __('admin/patients.form.region') }}</label>
                        <select name="region" class="form-control" id="add-region">
                            @foreach ($regions as $region)
                                <option value="{{ $region->id }}"
                                    {{ old('region', $patient->region_id) == $region->id ? 'selected' : '' }}>
                                    {{ $region->region }}
                                </option>
                            @endforeach
                        </select>
                    </div>
                    <div class="w-100 mb-3">
                        <label for="add-address" class="col-form-label">
                            {{ __('admin/patients.form.address') }}
                        </label>
                        <input type="text" name="address" class="form-control" id="add-address"
                            value="{{ old('address', $patient->address) }}">
                    </div>
                </div>
                <div class="col-12 col-lg-6">
                    <label for="add-comment" class="col-form-label">
                        {{ __('admin/patients.form.comment') }}
                    </label>
                    <textarea name="comment" class="form-control" rows="5"
                        id="add-comment">{{ old('comment', $patient->comment) }}</textarea>
                </div>
            </div>
            <div class="row mt-4">
                <div class="col">
                    <h4>{{ __('admin/patients.form.account_info') }}</h4>
                    <hr>
                </div>
            </div>
            <div class="form-group row mb-3">
                <div class="col-6">
                    <label for="add-password" class="col-form-label required">
                        {{ __('admin/patients.form.password') }}
                        <small class="muted">(8 chars minimum)</small>
                    </label>
                    <input type="text" name="password" class="form-control" id="add-password" value="">
                    <label id="pass-suggestion" class="mt-3 text-info">
                        {{ __('admin/patients.form.suggestion') }}
                        <span class="bg-light">{{ $gen_password }}</span>
                    </label>
                </div>
                <div class="col-6">
                    <label for="add-cpassword"
                        class="col-form-label required">{{ __('admin/patients.form.cpassword') }}</label>
                    <input type="text" name="cpassword" class="form-control" id="add-cpassword" value="">
                </div>
            </div>
            <div class="form-group">
                <div class="custom-control custom-checkbox mb-2">
                    <input type="checkbox" name="blocked" {{ old('blocked', $patient->is_blocked) ? 'checked' : '' }}
                        class="custom-control-input" value="1" id="is-blocked">
                    <label class="custom-control-label"
                        for="is-blocked">{{ __('admin/patients.form.is_blocked') }}</label>
                </div>
                <div class="custom-control custom-checkbox mb-2">
                    <input type="checkbox" name="notify" class="custom-control-input" value="1" id="notify">
                    <label class="custom-control-label" for="notify">
                        {{ __('admin/patients.form.notify') }}
                    </label>
                </div>
            </div>
            <div class="form-group row">
                <x-admin.form.save-button title="{{ __('admin/common.btn.save') }}" />
            </div>
        </form>
    </div>
    <script>
        $(document).ready(function() {

            $('#pass-suggestion').on('click', function() {

                let pass = $('#pass-suggestion > span').html();

                $('#add-password').val(pass);
                $('#add-cpassword').val(pass);

            });

            var start_date = moment().subtract(70, "years").format("YYYY-MM-DD");
            var default_date = moment().subtract(25, "years").format("YYYY-MM-DD");
            $('#add-dob').datepicker({
                format: 'yyyy-mm-dd',
                endDate: '0d',
                startdate: start_date,
                defaultViewDate: default_date,
            });
        });
    </script>
</div>
