<div class="row">
    <div class="col-12 d-flex mb-5">
        @if (has_permission('admin.patients.add'))
            <x-admin.form.add-button title="{{ __('admin/patients.btn.add') }}"
                link="{{ route('admin.patients.add') }}" :margin="'mr-3'" :size="'sm'" :target="'true'" />
        @endif
        @if (has_permission('admin.appointments.add'))
            <x-admin.form.add-button title="{{ __('admin/appointments.btn.add') }}"
                link="{{ route('admin.appointments.add') }}" :margin="'mr-3'" :size="'sm'" :target="'true'" />
        @endif
        @if (has_permission('admin.complaints.add'))
            <x-admin.form.add-button title="{{ __('admin/complaints.btn.add') }}"
                link="{{ route('admin.complaints.add') }}" :margin="'mr-3'" :size="'sm'" :target="'true'" />
        @endif
        @if (has_permission('admin.users.add'))
            <x-admin.form.add-button title="{{ __('admin/users.btn.add') }}" link="{{ route('admin.users.add') }}"
                :margin="'mr-3'" :size="'sm'" :target="'true'" />
        @endif
        @if (has_permission('admin.services.add'))
            <x-admin.form.add-button title="{{ __('admin/treatments.btn.add') }}"
                link="{{ route('admin.treatments.add') }}" :margin="'mr-3'" :size="'sm'" :target="'true'" />
        @endif
    </div>
</div>
<div class="row">
    <div class="col-12">
        <div class="alert alert-danger alert-dismissible fade show text-right" role="alert" style="direction: rtl;">
            <span><strong>تنويه!</strong> عند بدء الجلسة للمراجع، نرجو الضغط على زر Admit في صندوق Patients in reception لتحديد الأخصائي و بدء الجلسة. عدم بدء الجلسة يتسبب بضرر كبير في التقارير و تلف في البيانات</span>
            <button type="button" class="close" data-dismiss="alert"
                aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    </div>
</div>
<div class="row">
    {{-- Today's appointments --}}
    <div class="col-12 col-xxl-5">
        <div class="card elevation-0 border direct-chat direct-chat-primary">
            <div class="card-header">
                <div class="d-flex">
                    <h3 class="card-title">
                        <i class="ion ion-clipboard mr-1"></i>
                        Today's appointments
                    </h3>
                    <div class="card-tools ml-auto">
                        <small class="text-muted">
                            {{ sprintf(__('admin/dashboard.reception.app_count'), $appointments->count()) }}
                        </small>
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                          <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="direct-chat-messages">
                    <table class="table table-hover table-responsive">
                        <thead>
                            <tr>
                                <th>{{ __('admin/appointments.columns.ref_number') }}</th>
                                <th>{{ __('admin/appointments.columns.patient_name') }}</th>
                                <th>{{ __('admin/appointments.columns.start_time') }}</th>
                                <th>{{ __('admin/appointments.columns.status') }}</th>
                                <th>{{ __('admin/common.cols.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($appointments as $app)
                                <tr>
                                    <td>{{ $app->ref_number }}</td>
                                    <td>{{ $app->patient_name }}</td>
                                    <td>{{ date('h:i A', strtotime($app->start_time)) }}</td>
                                    <td>{{ $app->status }}</td>
                                    <td>
                                        <button type="button" data-href="{{ route('admin.dashboard.check_in', $app) }}"
                                            class="btn btn-success btn-check-in btn-sm" data-toggle="modal"
                                            data-target="#check-in-patient-modal"
                                            title="{{ __('admin/common.buttons.check_in') }}">
                                            <i class="fas fa-sign-in-alt"></i>
                                        </button>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer d-flex">
            </div>
        </div>
    </div>
    {{-- Checked-in --}}
    <div class="col-12 col-xxl-6">
        <div class="card elevation-0 border direct-chat direct-chat-primary">
            <div class="card-header">
                <div class="d-flex">
                    <h3 class="card-title">
                        <i class="ion ion-clipboard mr-1"></i>
                        {{ __('admin/dashboard.reception.in_reception') }}
                    </h3>
                    <div class="card-tools ml-auto">
                        <small class="text-muted">
                            {{ sprintf(__('admin/dashboard.reception.count'), $checked_in_appointments->count()) }}
                        </small>
                        <button type="button" class="btn btn-tool" data-card-widget="collapse">
                          <i class="fas fa-minus"></i>
                        </button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="direct-chat-messages">
                    <table class="table table-hover table-responsive">
                        <thead>
                            <tr>
                                <th>{{ __('admin/appointments.columns.patient_name') }}</th>
                                <th>{{ __('admin/appointments.columns.treatment') }}</th>
                                <th>{{ __('admin/appointments.columns.scheduled') }}</th>
                                <th>{{ __('admin/appointments.columns.start_time') }}</th>
                                <th>{{ __('admin/appointments.columns.checked_in_at') }}</th>
                                <th>{{ __('admin/common.cols.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($checked_in_appointments->count() > 0)
                                @foreach ($checked_in_appointments as $appointment)
                                    <tr>
                                        <td>{{ $appointment->patient->full_name }}</td>
                                        <td>{{ $appointment->treatment->treatment }}</td>
                                        <td class="text-center">
                                            @if ($appointment->scheduled)
                                                <span class="text-success">
                                                    {{  __('admin/common.text.yes') }}
                                                </span>    
                                            @else
                                                <span class="text-danger">
                                                    {{  __('admin/common.text.no') }}
                                                </span>
                                            @endif
                                        </td>
                                        <td class="text-center">
                                        @if ($appointment->scheduled)
                                            {{ date('h:i A', strtotime($appointment->start_time)) }}
                                        @else
                                            -
                                        @endif
                                        </td>
                                        <td>
                                            {{ date('h:i A', strtotime($appointment->checked_in_at)) }}
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-primary btn-sm btn-admit-modal" title="Admit" data-href="{{ route('admin.dashboard.admit',$appointment) }}">
                                                <i class="fas fa-sign-in-alt"></i>
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="4" class="text-center"> {{ __('admin/common.msgs.no_results') }}</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer d-flex">
                <button type="button" id="btn-add-no-app-patient" data-toggle="modal"
                    data-target="#no-app-patient-modal" class="btn btn-success btn-sm ml-auto">
                    <i class="fas fa-plus"></i>
                    Add patient
                </button>
            </div>
        </div>
    </div>
    {{-- Busy Physicians With Patients --}}
    <div class="col-12 col-xxl-6">
        <div class="card elevation-0 border direct-chat direct-chat-primary">
            <div class="card-header">
                <div class="d-flex">
                    <h3 class="card-title">
                        <i class="ion ion-clipboard mr-1"></i>
                        Patients with Physicians
                    </h3>
                    <div class="ml-auto">
                        <small class="text-muted">
                            {{ sprintf(__('admin/dashboard.reception.count'), $active_sessions->count()) }}
                        </small>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div class="direct-chat-messages">
                    <table class="table table-hover table-responsive">
                        <thead>
                            <tr>
                                <th>{{ __('admin/appointments.columns.patient_name') }}</th>
                                <th>{{ __('admin/appointments.columns.physician') }}</th>
                                <th>{{ __('admin/appointments.columns.admitted_at') }}</th>
                                <th>{{ __('admin/appointments.columns.session_period') }}</th>
                                <th>{{ __('admin/common.cols.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if ($active_sessions->count() > 0)
                                @foreach ($active_sessions as $appointment)
                                    <tr>
                                        <td>{{ $appointment->patient->full_name }}</td>
                                        <td>{{ $appointment->physician->full_name }}</td>
                                        <td>{{ date('h:i A', strtotime($appointment->admitted_at)) }}</td>
                                        <td>
                                            @php
                                                $treatment_period = $appointment->treatment->session_period;
                                                $expected_end_time = date('h:i A', strtotime($appointment->admitted_at .'+'. $treatment_period.' minutes'))
                                            @endphp
                                            {{ $expected_end_time }}
                                        </td>
                                        <td>
                                            <button type="button" data-href="{{ route('admin.dashboard.end_session', $appointment) }}"
                                                class="btn btn-danger btn-end-session btn-sm" data-toggle="modal"
                                                data-target="#end-session-modal"
                                                title="{{ __('admin/common.buttons.end_session') }}">
                                                <i class="far fa-stop-circle"></i>
                                                إنهاء الجلسة
                                            </button>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="4" class="text-center"> {{ __('admin/common.msgs.no_results') }}</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer d-flex">
                <button type="button" id="btn-admit" class="btn btn-success btn-sm ml-auto">
                    <i class="fas fa-sign-in-alt"></i>
                    {{ __('admin/common.buttons.admit') }}
                </button>
            </div>
        </div>
    </div>

    {{-- ########################################## --}}
    {{-- Checked-in Modal --}}
    <div class="modal fade" id="check-in-patient-modal" tabindex="-1" aria-labelledby="check-in-patient-modal-label"
        data-backdrop="static" data-keyboard="false" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="check-in-patient-modal-label">Check-in Patient</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Has the patient arrived?
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-secondary btn-sm"
                        data-dismiss="modal">{{ __('admin/common.buttons.close') }}</button>
                    <a href="#"
                        class="btn btn-success btn-confirm-check-in">{{ __('admin/common.buttons.check_in') }}</a>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="end-session-modal" tabindex="-1" aria-labelledby="end-session-modal-label"
        data-backdrop="static" data-keyboard="false" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="end-session-modal-label">End Session</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                {!! __('admin/dashboard.end_session') !!}
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-secondary btn-sm"
                        data-dismiss="modal">{{ __('admin/common.buttons.close') }}</button>
                    <a href="#"
                        class="btn btn-danger btn-confirm-end-session">{{ __('admin/common.buttons.end_session') }}</a>
                </div>
            </div>
        </div>
    </div>
    {{-- Admission Modal --}}
    <div class="modal fade" id="admit-patient-modal" tabindex="-1" aria-labelledby="admit-patient-modal-label"
        data-backdrop="static" data-keyboard="false" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="admit-patient-modal-label">Admit Patient</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <ul class="list-unstyled">
                    </ul>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-secondary btn-sm"
                        data-dismiss="modal">{{ __('admin/common.buttons.close') }}</button>
                    <a href="#" class="btn btn-primary btn-admit">{{ __('admin/common.buttons.admit') }}</a>
                </div>
            </div>
        </div>
    </div>
    {{-- Patients Without Appointments Modal --}}
    <div class="modal fade" id="no-app-patient-modal" tabindex="-1" aria-labelledby="no-app-patient-modal-label"
        data-backdrop="static" data-keyboard="false" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <form id="patient-no-app-form" action="{{ route('admin.dashboard.add_patient_no_app') }}"
                    method="POST" enctype="multipart/form-data">
                    <div class="modal-header">
                        <h5 class="modal-title" id="no-app-patient-modal-label">Admit Patient</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        @csrf
                        <div class="form-group">
                            <label for="no-app-patient">Patient</label>
                            <select name="no-app-patient" class="form-control selectpicker" data-live-search="true"
                                id="no-app-patients">
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="no-app-patient">Treatment</label>
                            <select name="no-app-treatment" class="form-control selectpicker" data-live-search="true"
                                id="no-app-treatments">
                                @foreach ($treatments as $treatment)
                                    <option value="{{ $treatment->id }}">{{ $treatment->treatment }}</option>
                                @endforeach
                            </select>
                        </div>

                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-secondary btn-sm"
                            data-dismiss="modal">{{ __('admin/common.buttons.close') }}</button>
                        <button type="submit"
                            class="btn btn-primary">{{ __('admin/common.buttons.check_in') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script>
        $(document).ready(function() {

            $('.btn-check-in').on('click', function(e) {

                e.preventDefault();

                let href = $(this).attr('data-href');

                $('#check-in-patient-modal .btn-confirm-check-in').attr('href', href);

                $('#check-in-patient-modal').modal('show');

            });
            $('.btn-end-session').on('click', function(e) {

                e.preventDefault();

                let href = $(this).attr('data-href');

                $('#end-session-modal .btn-confirm-end-session').attr('href', href);

                $('#end-session-modal').modal('show');

            });

            $('#admit-patient-modal').on('show.bs.modal	', function() {

                $.ajax({
                    type: "GET",
                    url: "{{ route('admin.dashboard.get_free_physicians') }}",
                    dataType: "JSON",
                    error: function(XMLHttpRequest) {
                        alert('error');
                        $('#loading-overlay').removeClass('is-active');
                    },
                    success: function(response) {

                        let html = '';

                        $.each(response.users, function(k, v) {
                            html += '<li class="mb-1">';
                            html += '<div class="sam-custom-radio">';
                            html += '<input type="radio" id="physician-' + k +
                                '" name="physician" value="' + v.id + '">';
                            html += '<label for="physician-' + k +
                                '" class="w-100 text-left">' + v.first_name + ' ' + v
                                .last_name + '</label>';
                            html += '</div>';
                            html += '</li>';
                        });

                        $('#admit-patient-modal').find('.modal-body ul').html(html);
                    }
                });
            });

            $('#btn-add-no-app-patient').on('click', function(e) {
                $.ajax({
                    type: "GET",
                    url: "{{ route('admin.dashboard.get_no_app_patients') }}",
                    dataType: "JSON",
                    error: function(XMLHttpRequest) {
                        alert('error');
                        $('#loading-overlay').removeClass('is-active');
                    },
                    success: function(response) {

                        let html = '';

                        $.each(response.patients, function(k, v) {

                            html += '<option value="' + v.id + '" data-subtext="' + v
                                .mobile + '">' + v.first_name + ' ' + v.last_name +
                                '</option>';

                        });

                        $('#no-app-patients').html(html);
                        $('#no-app-patients').selectpicker('refresh');
                    }
                });

            });

            $('.btn-admit-modal').on('click',function(e){

                e.preventDefault();

                let href = $(this).attr('data-href');

                $('#admit-patient-modal .btn-admit').attr('href', href);

                $('#admit-patient-modal').modal('show');

            });


            $('#admit-patient-modal .btn-admit').on('click',function(e){
                
                e.preventDefault();

                let formData = new FormData();
                formData.append('free-physician',$('input[name="physician"]:checked').val());
                let url = $(this).attr('href');

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                });

                $.ajax({
                    type: "POST",
                    url: url,
                    data: formData,
                    dataType: 'json',
                    contentType: false,
                    processData: false,
                    cache: false,
                    success: function(data) {
                        console.log(data);
                        if (data.success) {
                            window.location.href = "{{ route('admin.dashboard') }}";
                        }
                    }
                });

            })


            $('.btn-check-in').on('click', function(e) {

                e.preventDefault();

                let href = $(this).attr('data-href');

                $('#check-in-patient-modal .btn-confirm-check-in').attr('href', href);

                $('#check-in-patient-modal').modal('show');

            });


          /*   $('#patient-no-app-form').on('submit', function(e) {

                e.preventDefault();

                let form = $(this);
                let formData = new FormData(form[0]);
                let url = form.attr('action');

                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    error: function(xhr) {

                        let parsed = JSON.parse(xhr.responseText);

                        $('#error-alerts').remove();

                        let html = '<div id="error-alerts" class="col-12">';
                        html +=
                            '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
                        //$.each(parsed.error, function(key, err) {
                        html += '<span>' + parsed.error + '</span></br>';
                        //});
                        html +=
                            '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>';
                        html += '</div>';
                        html += '</div>';

                        $('.content-body').prepend(html);
                    }
                });

                $.ajax({
                    type: "POST",
                    url: url,
                    data: formData,
                    dataType: 'json',
                    contentType: false,
                    processData: false,
                    cache: false,
                    success: function(data) {
                        console.log(data);
                        if (data.success) {
                            window.location.href = "{{ route('admin.dashboard') }}";
                        }
                    }
                });
                return false;


            }); */

        });
    </script>

</div>
