<div class="col-12">
    <div class="card">
        <div class="card-body">
            <table class="table table-hover table-bordered">
                <thead>
                    <tr>
                        <th>{{ __('admin/appointments.columns.patient_name') }}</th>
                        <th>{{ __('admin/appointments.columns.treatment') }}</th>
                        <th>{{ __('admin/common.cols.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($appointments as $appointment)
                        <tr>
                            <td>
                                {{ $appointment->patient->full_name }}
                            </td>
                            <td>{{ $appointment->treatment->treatment }}</td>
                            <td>
                                <a href="{{ route('admin.patients.info',$appointment->patient)}}" target="_blank" class="btn btn-purple btn-sm">
                                    <i class="fas fa-info-circle"></i>
                                </a>
                                @if ( !$appointment->finished_at )
                                    <button type="button"
                                        data-href="{{ route('admin.dashboard.end_session', $appointment) }}"
                                        class="btn btn-danger btn-end-session btn-sm" data-toggle="modal"
                                        data-target="#end-session-modal"
                                        title="{{ __('admin/common.buttons.end_session') }}">
                                        <i class="far fa-stop-circle"></i>
                                    </button>
                                @else
                                    <a href="{{ route('admin.pretests.add') }}" target="_blank" class="btn btn-secondary btn-sm" title="{{ __('admin/pretests.add_title')}}">
                                        <i class="fas fa-file-archive"></i>
                                    </a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <div class="modal fade" id="end-session-modal" tabindex="-1" aria-labelledby="end-session-modal-label"
        data-backdrop="static" data-keyboard="false" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="end-session-modal-label">End Session</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    {!! __('admin/dashboard.end_session') !!}
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-secondary btn-sm"
                        data-dismiss="modal">{{ __('admin/common.buttons.close') }}</button>
                    <a href="#" class="btn btn-danger btn-confirm-end-session">
                        {{ __('admin/common.buttons.end_session') }}
                    </a>
                </div>
            </div>
        </div>
    </div>
    <script>
        $('.btn-end-session').on('click', function(e) {

            e.preventDefault();

            let href = $(this).attr('data-href');

            $('#end-session-modal .btn-confirm-end-session').attr('href', href);

            $('#end-session-modal').modal('show');

        });
    </script>
</div>
