<div class="col-12 pb-3">
    <div class="card w-100 border elevation-0">
        <div class="card-body">
            <div class="d-flex w-100 justify-content-between">
                <small class="mt-3 text-muted">{{ __('admin/complaints.columns.is_resolved') }}:
                    {!! $complaint->getStatus() !!}</small>
                <small class="mt-3 text-muted">{{ __('admin/complaints.columns.complaint_date') }}:
                    {{ $complaint->complaint_date->format('Y-m-d') }}</small>
                <small class="mt-3 text-muted">{{ __('admin/complaints.columns.created_at') }}:
                    {{ $complaint->created_at->format('Y-m-d') }}</small>
            </div>
            <hr>
            <div class="w-100 mt-4">
                <p>{{ $complaint->description }}</p>
            </div>

            <div class="d-flex w-100 justify-content-start pt-2 mt-5 border-top">
                <button type="button" class="btn btn-sm btn-purple" data-toggle="modal"
                    data-target="#patient-info-modal">
                    <i class="fas fa-exclamation-circle"></i>
                    Patient Info
                </button>
                <a href="{{ route('admin.appointments', $patient->id) }}" class="btn btn-sm btn-secondary ml-2"
                    target="_blank">
                    <i class="fas fa-calendar-alt"></i>
                    History
                </a>
                @if ($complaint->attachment)
                    <span class="font-weight-bold my-auto ml-auto mr-3">
                        {{ __('admin/complaints.columns.attachment') }}
                    </span>
                    <a href="{{ route('admin.complaints.download', $complaint->id) }}" class="btn btn-sm btn-info"
                        target="_blank">
                        {{ __('admin/complaints.btn.download') }}
                    </a>
                @endif
            </div>
        </div>
    </div>
</div>
<div class="col-12">
    <div id="chat-box" class="card direct-chat direct-chat-primary">
        <div class="card-header">
            <h3 class="card-title">Direct Chat</h3>
        </div>
        <div class="card-body pb-3">
            <div id="chat-box-messages" class="direct-chat-messages">
                {!! $complaint_messages !!}
            </div>
        </div>
        <div class="card-footer">
            <form action="#" method="post">
                @csrf
                <div id="send-message-alerts" class="form-group"></div>
                <div class="input-group">
                    <input type="text" name="message" id="chat-message" placeholder="Type Message ..."
                        class="form-control" onkeyup="countChar(this)">
                    <span class="input-group-append">
                        <button type="button" id="send-message" class="btn btn-primary">Send</button>
                    </span>
                </div>
                <small id="char-count" class="text-muted"></small><small class="text-muted">/250</small>
            </form>
            <input type="hidden" id="msg-id" value="{{ $last_message_id }}">
        </div>
    </div>
</div>

<div class="modal fade" id="patient-info-modal" data-backdrop="static" data-keyboard="false" tabindex="-1"
    aria-labelledby="patient-info-modal-label" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="patient-info-modal-label">{{ $patient->getFullName() }}</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="card w-100 elevation-0 mb-0">
                    <div class="card-body">
                        <table class="table table-borderless">
                            <tbody>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients.info_cards.full_name') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->getFullNameAttribute() }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients.info_cards.age') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->getAgeAttribute() }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients.info_cards.gender') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->getGender() }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients.info_cards.region') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->region->region }}</span>
                                    </td>
                                </tr>
                                <tr>
                                    <td>
                                        <span class="font-weight-bold mr-2">
                                            {{ __('admin/patients.info_cards.address') }}
                                        </span>
                                    </td>
                                    <td>
                                        <span>{{ $patient->address }}</span>
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-sm"
                    data-dismiss="modal">{{ __('admin/common.buttons.close') }}</button>
            </div>
        </div>
    </div>
</div>


<script>
    $(document).ready(function() {

        $('#chat-box form').on('submit',function(e){
            e.preventDefault();
            
            $('#send-message').trigger('click');
            return false;
        });


        $('#send-message').on('click', function(e) {
            
            if ( !$('#chat-message').val() ) {
                return false;
            }

            e.preventDefault();

            var formData = $('#chat-box form').serialize();

            $.ajax({
                type: "POST",
                url: "{{ route('admin.complaints.send_message', $complaint->id) }}",
                data: formData,
                dataType: 'json',
                cache: false,
                processData: false,

                error: function(XMLHttpRequest) {
                    console.log(XMLHttpRequest.responseText);
                },
                success: function(response) {
                    $('#msg-id').val(response.last_id);
                    $('#chat-box-messages').append(response.message);
                    $('#chat-message').val('');
                    $('#char-count').html('0');
                }
            });
        });

        setInterval(function() {
            $.ajax({
                type: "GET",
                url: "{{ route('admin.complaints.refresh_messages', $complaint->id) }}/" + $(
                    '#msg-id').val(),
                dataType: 'json',
                cache: false,
                processData: false,
                error: function(XMLHttpRequest) {
                    console.log(XMLHttpRequest.responseText);
                },
                success: function(response) {
                    $('#msg-id').val(response.last_id);
                    $('#chat-box-messages').append(response.messages);
                }
            });
        }, 5000);
    });

    function countChar(val) {
        var len = val.value.length;
        if (len >= 250) {
            val.value = val.value.substring(0, 250);
        } else {
            $('#char-count').html(len);
        }
    };
</script>
