<?php

namespace App\Rules;

use Illuminate\Contracts\Validation\Rule;

class ArEnAlphaSpace implements Rule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return (bool) preg_match('/^[\p{Arabic}a-zA-Z \p{N}]+\h?[\p{N}\p{Arabic}a-zA-Z ]*$/u', $value);
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return trans('validation.ar_en_alpha_num_space');
    }
}
