<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Review extends Model
{
    use HasFactory;

    protected $fillable = ['appointment_id','rating','review'];

    /**
     * Scope a query to filter by allowed branches only
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeAllowedAppointments($query)
    {
        return (!is_admin() && user_role()) ? $query->whereIn('reviews.appointment_id', allowed_appointments()) : $query;
    }

    public function patient()
    {
        return $this->belongsTo(Patient::class);
    }
}
