<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Region extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $fillable = ['region'];

    //---------------------------------------------
    /**
     * Patients
     *
     * @return void
     */
    public function patients(){
        
        return $this->hasMany(Patient::class);
    
    }
    //---------------------------------------------
    /**
     * Branches
     *
     * @return void
     */
    public function branches(){
        
        return $this->hasMany(Branch::class);
    
    }

}
