<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PatientPretest extends Model
{
    use HasFactory;

    protected $table = 'patient_pretest';

    protected $fillable = ['patient_id','pretest_id','created_by','title','form','form_date'];


    
    /**
     * Scope a query to filter by allowed patients only
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeAllowedPatients($query)
    {

        return (!is_admin() ) ? $query->whereIn('patient_id', allowed_patients()) : $query;
        
    }

    public function patients(){
        //return $this->belongsToMany(Patient::class)->withPivot(['id','form','created_at']);
        return $this->belongsTo(Patient::class);
    }


}
