<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class PatientAuthCheck
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {

        if ( $request->path() == 'patient/verify' && !session()->has('ver_no') ){
            return redirect()->route('website.home');
        }

        if ( session()->has('patient_info.patient_id') ){

            if ( $request->path() == 'patient/register' ){
                return redirect()->route('patient.dashboard');
            }

            if ( $request->path() == 'patient/verify' ){
                return redirect()->route('patient.dashboard');
            }

            if ( $request->path() == 'patient/login' ){

                return redirect()->route('patient.dashboard');
            }

            if ( $request->path() == 'patient/forgot' ){
            
                return redirect()->route('patient.dashboard');

            }

        }

        if ( !session()->has('patient_info.patient_id') ){

            if ( $request->path() == 'patient/register' ){
                return $next($request);
            }

            if ( $request->path() == 'patient/verify' ){
                return $next($request);
            }

            if ( $request->path() == 'patient/login' ){

                return $next($request);
            }

            if ( $request->path() == 'patient/forgot' ){

                return $next($request);
            }

            return redirect()->route('patient.login');        
        
        }

        return $next($request);
    }
}
