<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class Localization
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        
        if (session()->has('locale')) {

            $locale = session()->get('locale');
            
        
        }else{

            $locale = substr($request->server('HTTP_ACCEPT_LANGUAGE'), 0, 2);

            if ( $locale != 'ar' && $locale != 'en') {
                
                $locale = 'en';
            
            }

        }

        App::setLocale($locale);

        return $next($request);
    }
}
