<?php

namespace App\Exports;

use App\Models\Complaint;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ExportComplaints implements FromCollection, WithHeadings
{
    /**
     * @return \Illuminate\Support\Collection
    */
    public function headings(): array
    {
        return [
            '#',
            __('admin/complaints.columns.complaint_date'),
            __('admin/complaints.columns.patient_name'),
            __('admin/complaints.columns.description'),
            __('admin/complaints.columns.is_resolved'),
            __('admin/complaints.columns.created_at'),
            __('admin/complaints.columns.updated_at'),
            __('admin/complaints.columns.user_name'),
        ];

    }

    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        return Complaint::all();
    }
}
