<?php

namespace App\Console\Commands;

use App\Models\Appointment;
use Illuminate\Console\Command;

class AppointmentNotifCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'appointment_notf_cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Send automatic reminder via push notifications to patients. Runs at 08:00 PM everyday.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $next_date = date('Y-m-d', strtotime(' +1 day'));

        $appointments = Appointment::where('appointment_date',$next_date)->get();

        if ( $appointments ){

            $tokens = [];

            foreach ( $appointments as $app){

                 $tokens[] = $app->patient->device_token;

            }

            // To be completed






            
        }


        return 0;
    }
}
