<?php get_header();
setup_postdata($post); ?>
<div class="container-fluid mb-5">
    <div class="row bg-gray-25">
        <section id="page-title" class="col-12 rounded-4 pt-3">
            <h1 class="text-center"><?php the_title(); ?></h1>
            <div class="d-flex">
                <?php if (function_exists('yoast_breadcrumb')) {
                    yoast_breadcrumb('<p id="breadcrumbs" class="mx-auto">', '</p>');
                } ?>
            </div>
        </section>
    </div>
</div>
<div id="single-blog-post" class="container py-5">
    <div class="container">
        <div class="row">
            <div class="col-12 col-lg-8">
                <div class="card border-0 w-100">
                    <a href="<?php the_permalink(); ?>" class="text-center">
                        <?php the_post_thumbnail('featured-img', array('class' => 'img-fluid')); ?>
                    </a>
                    <div class="card-body px-0">
                        <a href="<?php the_permalink(); ?>" class="fs-3 card-title"><?php the_title(); ?></a>
                        <p class="card-text mt-3">
                            <?= the_content(); ?>
                        </p>
                        <p class="card-text mt-1 text-sm">
                            <i class="fas fa-calendar-alt text-secondary"></i> <?= get_the_date(); ?>
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-4">
                <div class="card w-100">
                    <div class="card-header bg-gold">
                        <?= pll_e('recent_posts'); ?>
                    </div>

                    <?php

                    $args = [
                        'number' => 5,
                        'post_status'   => 'publish',
                        'suppress_filters' => true,
                        'orderby' => 'date',
                        'order' => 'DESC',
                        'post__not_in' => [get_the_ID()]
                    ];

                    $posts = get_posts($args);?>
                    <div class="card-body px-0">
                    <?php if ( $posts ): ?>
                        <ul class="list-group list-group-flush">
                            <?php foreach ( $posts as $post ) : ?>
                                <li class="list-group-item">
                                    <div class="d-flex">
                                        <?= get_the_post_thumbnail($post->ID,'blog-small-thumb'); ?>
                                        <div class="blog-excerpt ms-3 my-auto">
                                            <a href="<?= get_the_permalink($post->ID); ?>" class="fs-5"><?= $post->post_title; ?></a>
                                            </br>
                                            <?= excerpt(10); ?>
                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; ?>
                        </ul>
                    <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>