<?php get_header();
setup_postdata($post); ?>
<div class="container-fluid mb-5">
    <div class="row bg-gray-25">
        <section id="page-title" class="col-12 rounded-4 pt-3">
            <h1 class="text-center"><?php the_title(); ?></h1>
            <div class="d-flex">
                <?php if (function_exists('yoast_breadcrumb')) {
                    yoast_breadcrumb('<p id="breadcrumbs" class="mx-auto">', '</p>');
                } ?>
            </div>
        </section>
    </div>
</div>
<?php wp_reset_postdata(); ?>
<div id="single-zain-treatment" class="container py-5">
    <div class="row">
        <?php

        $current_treatment = get_queried_object();

        $parent_clinics = get_the_terms($current_treatment->ID, 'zain_clinics');

        if ($parent_clinics) : ?>
            <div class="col-12 col-lg-4 col-xl-3">
                <?php
                $args = [
                    'number' => 10,
                    'orderby' => 'sort_order',
                    'order' => 'ASC',
                    'post_type' => 'clinic_treatments',
                    'post_status' => 'publish',
                    'suppress_filters' => true,
                    'tax_query' => [
                        [
                            'taxonomy' => 'zain_clinics',
                            'field' => 'term_id',
                            'terms' => $parent_clinics[0]->term_id
                        ]
                    ],
                    'post__not_in' => [$current_treatment->ID]
                ];

                $related_treatments = get_posts($args);

                if ($related_treatments) : ?>
                    <div class="card shadow-sm border-0 h-100">
                        <div class="card-body">
                            <ul class="nav flex-column">
                                <?php foreach ($related_treatments as $related_treatment) : ?>
                                    <li class="nav-item border-bottom border-light">
                                        <a class="nav-link fw-500" aria-current="page" href="<?= get_permalink($related_treatment->ID); ?>">
                                            <?= $related_treatment->post_title; ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
        <div class="col-12 col-lg-8 col-xl-9">
            <div class="shadow-sm p-3">
                <div class="w-100 text-center mb-5">
                    <?php the_post_thumbnail('', ['class' => 'img-fluid ']); ?>
                </div>
                <h1 class="h4 mb-3"><?php the_title(); ?></h1>
                <?php the_content(); ?>
                <div class="mt-5 w-100 text-end">
                    <a href="#" class="btn btn-gold"><?= pll_e('book_appointment'); ?></a>
                </div>
            </div>
           
        </div>
    </div>
</div>
<?php get_footer(); ?>