<?php get_header(); ?>
<div class="container-fluid mb-5">
    <div class="row bg-gray-25">
        <section id="page-title" class="col-12 rounded-4 pt-3">
            <h1 class="text-center"><?php the_title(); ?></h1>
            <div class="d-flex">
                <?php if (function_exists('yoast_breadcrumb')) {
                    yoast_breadcrumb('<p id="breadcrumbs" class="mx-auto">', '</p>');
                } ?>
            </div>
        </section>
    </div>
</div>
<div id="contact-us" class="container py-5">
    <div class="row align-items-stretch">
        <div class="col-12 col-lg-5 fw-light">
            <h2 class="fs-2 text-capitalize text-gold-light"><?= pll_e('message_us'); ?></h2>
            <?= do_shortcode('[wpforms id="140"]'); ?>
        </div>
        <div class="col-12 col-lg-6 offset-lg-1">
            <h2 class="fs-2 text-capitalize text-gold-light"><?= pll_e('follow_us'); ?></h2>
            <div class="row social justify-content-between mt-5 pb-3">
                <?php
                $accounts = get_social_media_accounts();

                if ($accounts) :
                    foreach ($accounts as $title => $account) : ?>
                        <div class="col-6 col-md-4 col-lg-auto text-center mb-3 d-flex">
                            <a href="<?= $account['link']; ?>" class="me-4 mb-3 text-gold d-block text-center">
                                <span class="fa-stack fa-2x mx-auto">
                                    <i class="fas fa-circle fa-stack-2x"></i>
                                    <i class="<?= $account['icon']; ?> fa-stack-1x fa-inverse"></i>
                                </span>
                                </br>
                                <span class="text-dark"><?= $account['username']; ?></span>
                            </a>
                        </div>
                <?php endforeach;
                endif; ?>
            </div>
            <hr class="bg-gold">
            <h2 class="fs-2 text-capitalize text-gold-light my-4"><?= pll_e('branches'); ?></h2>
            <?php

            $branches = get_branches();

            if ($branches) : ?>
                <div id="branches" class="col offset-lg-1 my-3">
                    <?php foreach ($branches as $branch) : ?>
                        <div class="branch d-flex mt-3 w-100">
                            <i class="fas fa-map-marker-alt fa-2x me-2 text-gold"></i>
                            <div class="d-flex flex-column">
                                <p class="text-dark fw-bolder"><?= $branch['name']; ?></p>
                                <p class="text-dark"><?= $branch['address']; ?></p>
                                <?php if ($branch['phone']) : ?>
                                    <p class="text-dark"><?= $branch['phone']; ?></p>
                                <?php endif; ?>
                                <?php if ($branch['mobile']) : ?>
                                    <p class="text-dark"><?= $branch['mobile']; ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php get_footer(); ?>