<?php

defined('ABSPATH') or exit; /* Prevent Direct Access */

/*****************************
 * Check required plugins
 *****************************/

/* Disable XML-RPC API */
add_filter('xmlrpc_enabled', '__return_false');
/** Polylang**/
include_once(ABSPATH . 'wp-admin/includes/plugin.php');

if (!is_plugin_active('polylang/polylang.php')) :

	echo 'Polylang plugin is required.';

	return false;

endif;

/** Yoast SEO **/
include_once(ABSPATH . 'wp-admin/includes/plugin.php');

if (!is_plugin_active('wordpress-seo/wp-seo.php')) :

	echo 'Yoast SEO plugin is required.';

	return false;

endif;

/** Advanced Custom Fields **/
include_once(ABSPATH . 'wp-admin/includes/plugin.php');

if (!is_plugin_active('advanced-custom-fields/acf.php')) :

	echo 'Advanced Custom Fields plugin is required.';

	return false;

endif;


/***************
 * Includes
 ***************/

/* Theme Setup */
include(get_template_directory() . '/includes/setup.php');

/* Admin Menu Customization */
include(get_template_directory() . '/includes/admin.php');

/* Enqueue (CSS & JS) */
include(get_template_directory() . '/includes/enqueue.php');

/* Navwalker (BS5 customized for material design) */
include(get_template_directory() . '/includes/bs5-navbar-walker.php');

/* Static String Translations */
include(get_template_directory() . '/includes/dictionary.php');

/* Static String Shortcodes */
/* include(get_template_directory() . '/includes/shortcodes.php'); */

/* Pagination */
include(get_template_directory() . '/includes/pagination.php');


/*******************
 * Enqueue scripts
 ******************/
add_action('wp_enqueue_scripts', 'sam_enqueue');
/* Theme setup */
add_action('after_setup_theme', 'sam_setup_theme');
/* Init widgets (from setup) */
add_action('widgets_init', 'sam_widgets_init');

/* Admin Panel Customization (from setup) */


/*====================
* Filters
=====================*/

/* Add default value for Image custom field */

function add_default_value_to_image_field($field)
{
	acf_render_field_setting($field, array(
		'label'			=> 'Default Image',
		'instructions'	=> 'Appears when creating a new post',
		'type'			=> 'image',
		'name'			=> 'default_value',
	));
}

/* This snippet is important if you want to utilize the default image value in the front end. */

function reset_default_image($value, $post_id, $field)
{
	if (!$value) {
		$value = $field['default_value'];
	}
	return $value;
}


add_filter('acf/load_value/type=image', 'reset_default_image', 10, 3);

add_action('acf/render_field_settings/type=image', 'add_default_value_to_image_field');
/* Hide admin bar */
add_filter('show_admin_bar', '__return_false');



remove_filter('the_content', 'wpautop');


/******************
 *  Image sizes
 *****************/
add_image_size('square-300', 300, 300, false);
add_image_size('square-150', 150, 150, false);
add_image_size('blog-small-thumb', 80, 80, false);





/*****************
 * Template Parts
 ******************/
function get_navbar()
{
	get_template_part('template-parts/navbar');
}

function get_front_page_about()
{
	get_template_part('template-parts/front-page/about');
}

function get_front_page_clinics()
{
	get_template_part('template-parts/front-page/clinics');
}

function get_front_page_testimonials()
{
	get_template_part('template-parts/front-page/testimonials');
}

function get_front_page_offers()
{
	get_template_part('template-parts/front-page/offers');
}

function get_front_page_specialists()
{
	get_template_part('template-parts/front-page/specialists');
}

function get_front_page_brands()
{
	get_template_part('template-parts/front-page/brands');
}

/*===========================
 *  Page Template Redirects
 ===========================*/

/* function sam_redirect_page_template($template)
{
	if (is_page('contact-us-ar'))
		$template = locate_template(array('page-contact-us.php', 'page.php'));
	elseif ( is_page('clinics-ar') ) 
		$template = locate_template(array('page-clinics.php', 'page.php'));
	return $template;
} 

add_filter('page_template', 'sam_redirect_page_template');*/
/*==================
* Custom Functions
===================*/

/**
 * Get Social Media Accounts
 *
 * @return array
 */
function get_social_media_accounts()
{

	$accounts = [];

	/* Facebook */
	$account = get_option('sam_social_accounts_facebook');

	if ($account) {

		$accounts['Facebook'] = [
			'icon' => 'fab fa-facebook-f',
			'link' => 'https://facebook.com/' . $account,
			'username' => $account
		];
	}

	/* Instagram */
	$account = get_option('sam_social_accounts_instagram');

	if ($account) {

		$accounts['Instagram'] = [
			'icon' => 'fab fa-instagram',
			'link' => 'https://instagram.com/' . $account,
			'username' => $account
		];
	}

	/* youtube */
	$account = get_option('sam_social_accounts_youtube');

	if ($account) {

		$accounts['Youtube'] = [
			'icon' => 'fab fa-youtube',
			'link' => 'https://youtube.com/' . $account,
			'username' => $account
		];
	}

	/* Whatsapp */
	$account = get_option('sam_social_accounts_whatsapp');

	if ($account) {


		$account = ltrim($account, '0');
		$account = ltrim($account, '+');

		$accounts['Whatsapp'] = [
			'icon' => 'fab fa-whatsapp',
			'link' => 'https://wa.me/' . $account,
			'username' => $account
		];
	}

	/* Telegram */
	$account = get_option('sam_social_accounts_telegram');

	if ($account) {

		$accounts['Telegram'] = [
			'icon' => 'fab fa-telegram',
			'link' => 'https://t.me/' . $account . '?start=<token>',
			'username' => $account
		];
	}

	return $accounts;

	/* snapchat */
	/* $account = get_option('sam_social_accounts_telegram');

	if ( $account ){

		$accounts[] = [
			'icon' => 'fab fa-whatsapp',
			'link' => 'https://t.me/'.$account.'?start=<token>'
		];
	} */
}


/**
 * Get Branches
 *
 * @return array
 */
function get_branches()
{

	$branches = [];

	$args = [
		'number' => 10,
		'orderby' => 'ID',
		'order' => 'ASC',
		'post_type' => 'branches',
		'post_status' => 'publish',
		'suppress_filters' => true,
	];

	$posts = get_posts($args);

	if ($posts) {


		foreach ($posts as $post) {
			
			$branch = [
				'id' => $post->ID,
				'name' => $post->post_title,
				'address' => $post->post_content,
				'phone' => get_field('branch_phone_number', $post->ID),
				'mobile' => get_field('branch_mobile_number', $post->ID),
				'start_time' => get_field('working_hours_start', $post->ID),
				'end_time' => get_field('working_hours_end', $post->ID),
				'days' => get_field('working_days', $post->ID),
			];

			$branches[] = $branch;
		}
	}

	return $branches;
}


/**
 * Trim excerpt by word count
 *
 * @param int $limit
 * @return string
 */
function excerpt($limit = 20)
{
	$excerpt = explode(' ', get_the_excerpt(), $limit);
	if (count($excerpt) >= $limit) {
		array_pop($excerpt);
		$excerpt = implode(" ", $excerpt) . '...';
	} else {
		$excerpt = implode(" ", $excerpt);
	}
	$excerpt = preg_replace('`[[^]]*]`', '', $excerpt);
	return $excerpt;
}
/**
 * Trim excerpt by word count
 *
 * @param int $limit
 * @return string
 */
function sam_content($limit = 20)
{
	$content = explode(' ', get_the_content(), $limit);
	if (count($content) >= $limit) {
		array_pop($content);
		$content = implode(" ", $content) . '...';
	} else {
		$content = implode(" ", $content);
	}
	$content = preg_replace('`[[^]]*]`', '', $content);
	return $content;
}

/* 
function content($limit)
{
	$content = explode(' ', get_the_content(), $limit);
	if (count($content) >= $limit) {
		array_pop($content);
		$content = implode(" ", $content) . '...';
	} else {
		$content = implode(" ", $content);
	}
	$content = preg_replace('/[.+]/', '', $content);
	$content = apply_filters('the_content', $content);
	$content = str_replace(']]>', ']]>', $content);
	return $content;
}
 */

 /*=====================================
 *  Fix custom post type pagination
 ========================================*/
/**
 * Wordpress has a known bug with the posts_per_page value and overriding it using
 * query_posts. The result is that although the number of allowed posts_per_page
 * is abided by on the first page, subsequent pages give a 404 error and act as if
 * there are no more custom post type posts to show and thus gives a 404 error.
 *
 * This fix is a nicer alternative to setting the blog pages show at most value in the
 * WP Admin reading options screen to a low value like 1.
 *
 */
function sam_custom_posts_per_page( $query ) {

    if ( $query->is_archive('clinic_treatments') ) {
        set_query_var('posts_per_page', 1);
    }
}
add_action( 'pre_get_posts', 'sam_custom_posts_per_page' );


