<?php 
/*
Template Name: Clinics List
*/

get_header(); ?>
<div class="container-fluid mb-5">
    <div class="row bg-gray-25">
        <section id="page-title" class="col-12 rounded-4 pt-3">
            <h1 class="text-center"><?php the_title(); ?></h1>
            <div class="d-flex">
                <?php if (function_exists('yoast_breadcrumb')) {
                    yoast_breadcrumb('<p id="breadcrumbs" class="mx-auto">', '</p>');
                } ?>
            </div>
        </section>
    </div>
</div>
<div id="page-clinics" class="container py-5">
    <?php

    $taxonomy = 'zain_clinics';
    $number   = get_option( 'posts_per_page' ); // number of terms to display per page

    // Setup:
    $page         = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
    $offset       = ( $page > 0 ) ?  $number * ( $page - 1 ) : 1;

    $args = [
        'taxonomy' => $taxonomy,
        'number' => $number,
        'offset' => $offset,
        'order_by' => 'name',
        'order' => 'ASC',
        'post_status'   => 'publish',
        'hide_empty' => false,
    ];

    $treatment_categories = get_terms($args);

    if ($treatment_categories) : ?>
        <div class="row">
            <?php foreach ( $treatment_categories as $category ) : ?>
                <div class="col-6 col-lg-4 col-xl-3 mb-3 d-flex align-items-stretch">
                    <div class="card w-100 d-flex">
                        <a href="<?= get_term_link($category); ?>" class="text-center h-100 bg-gray-25 py-3">
                            <img src="<?= get_field('t_category_main_image',$category); ?>" class="img-fluid opacity-75">
                        </a>
                        <div class="card-body d-flex flex-column text-start mt-4">
                            <h5 class="card-title text-center mb-4"><?= $category->name; ?></h5>
                            <p class="card-text font-sm fw-normal">
                                <?= excerpt(20); ?>
                            </p>
                            <a href="<?= get_term_link($category); ?>" class="btn btn-outline-gold mt-auto"><?= pll_e('view_details'); ?></a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        <div class="row">
            <div class="col-auto mx-auto mt-4">
                <?php bootstrap_term_pagination($taxonomy,$number); ?>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php get_footer(); ?>