<?php
/*
Template Name: Clinics List
*/
get_header(); ?>
<div class="container-fluid mb-5">
    <div class="row bg-gray-25">
        <section id="page-title" class="col-12 rounded-4 pt-3">
            <h1 class="text-center"><?= pll_e('blog_posts'); ?></h1>
            <div class="d-flex">
                <?php if (function_exists('yoast_breadcrumb')) {
                    yoast_breadcrumb('<p id="breadcrumbs" class="mx-auto">', '</p>');
                } ?>
            </div>
        </section>
    </div>
</div>
<div id="page-blog" class="container py-5">
    <?php

    $category = get_queried_object();  /* get current category */
    $posts_per_page = get_option('posts_per_page');  /* Number of posts per page */

    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1; // track which page to display

    $args = [
        'category' => $category->term_id,
        'posts_per_page' => $posts_per_page,
        'paged' => $paged,
        'post_status'   => 'publish',
        'suppress_filters' => true,
    ];

    $postslist = new WP_Query($args);

    //$posts = get_posts($args);

    if ($postslist->have_posts()) : ?>
        <div class="row">
            <?php while ($postslist->have_posts()) : $postslist->the_post(); ?>
                <div class="col-12 col-lg-10 col-xl-8 mx-auto align-items-stretch pb-4 mb-5 border-bottom">
                    <div class="card w-100 border-0">
                        <a href="<?php the_permalink(); ?>" class="text-center">
                            <?php the_post_thumbnail('featured-img', array('class' => 'img-fluid')); ?>
                        </a>
                        <div class="card-body px-0">
                            <a href="<?php the_permalink(); ?>" class="fs-3 card-title"><?php the_title(); ?></a>
                            <p class="card-text mt-3">
                                <?= sam_content(); ?>
                            </p>
                            <div class="card-text mt-1 text-sm d-flex">
                                <p class="my-auto">
                                    <i class="fas fa-calendar-alt text-secondary"></i> <?= get_the_date(); ?>
                                </p>
                                
                                <a href="<?= the_permalink(); ?>" class="ms-auto btn btn-gold btn-sm"><?= pll_e('read_more'); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endwhile; ?>
        </div>
        <div class="row">
            <div class="col-auto mx-auto mt-4">
                <?php echo bootstrap_pagination($postslist); ?>
            </div>
        </div>
    <?php endif; ?>

    <?php wp_reset_postdata(); ?>
</div>

<?php get_footer(); ?>