<?php

defined('ABSPATH') or exit; /* Prevent Direct Access */

function sam_setup_theme()
{
	/*Menu Theme support*/
	add_theme_support('menus');

	register_nav_menus(
		[
			'main-menu'     => __('Main Menu', 'Zain'),
		]
	);

	//Theme Customization

	/* Custom Header */

	add_theme_support('custom-header', [

		'video' => false,

	]);

	/* Post Thumbnails */
	add_theme_support('post-thumbnails');

	/* Excerpt to Pages	 */
	add_post_type_support('page', 'excerpt');

	/* Logo Support */
	add_theme_support('custom-logo', [

		/* 'height'      => 60, */

		/* 'width'       => 300, */

		'flex-height' => true,

		'flex-width'  => true,

		'header-text' => ['site-title', 'site-description'],

	]);
}

/**** Add widget ****/
function sam_widgets_init()
{

	register_sidebar(
		[
			'name'          => 'Footer - Col 1',
			'id'            => 'footer_col_1',
			'before_widget' => '<div class="col-6 col-md-3 col-xl-2 mx-auto mb-4 quick-links">',
			'after_widget'  => '</div>',
			'before_title'  => '<span class="h6 text-uppercase fw-bold mb-4">',
			'after_title'   => '</span>',
		]
	);
	register_sidebar(
		[
			'name'          => 'Footer - Col 2',
			'id'            => 'footer_col_2',
			'before_widget' => '<div class="col-6 col-md-3 col-xl-2 mx-auto mb-4 quick-links">',
			'after_widget'  => '</div>',
			'before_title'  => '<span class="h6 text-uppercase fw-bold mb-4">',
			'after_title'   => '</span>',
		]
	);
}
