<?php 

defined('ABSPATH') OR exit; /* Prevent Direct Access */


function sam_enqueue(){

	/******************
	* Register Styles
	*******************/

	/* LTR Styles */
	wp_register_style('sam_bs5', get_template_directory_uri() .'/assets/css/bootstrap.min.css' );
	wp_register_style('sam_style', get_template_directory_uri() .'/style.css',array(), 6, 'all' );
	wp_register_style('sam_swiper', get_template_directory_uri() .'/assets/css/swiper.min.css',array(), 6, 'all' );
	
	/* Fonts */
	wp_register_style('sam_cairo', 'https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500&display=swap',array(), 6, 'all' );
	wp_register_style('sam_noto_kufi', 'https://fonts.googleapis.com/css2?family=Noto+Kufi+Arabic:wght@400;600;700&display=swap',array(), 6, 'all' );
	wp_register_style('sam_mont', 'https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,300;0,400;0,500;0,600;1,300;1,400;1,500;1,600&display=swap',array(), 6, 'all' );
	
	/* RTl Styles */
	wp_register_style('sam_bs5_rtl', get_template_directory_uri() .'/assets/css/bootstrap.rtl.min.css' );
	wp_register_style('sam_style_rtl', get_template_directory_uri() .'/style-rtl.css',array(), 6, 'all' );
	
	/* General */
	wp_register_style('sam_fontawesome', get_template_directory_uri() .'/assets/css/fontawesome.min.css' );
	wp_register_style('sam_aos', 'https://unpkg.com/aos@2.3.1/dist/aos.css' );

	
	/*************** 
	* Register JS 
	**************/
	wp_register_script('sam_bs5js', get_template_directory_uri() . '/assets/js/bootstrap.bundle.min.js','',1,true);
	wp_register_script('sam_aosjs', 'https://unpkg.com/aos@2.3.1/dist/aos.js','',1,true);
	wp_register_script('sam_swiperjs',  get_template_directory_uri() . '/assets/js/swiper.min.js','',1,true);
	

	if ( is_rtl() ) {

		wp_enqueue_style('sam_bs5_rtl');					
		wp_enqueue_style('sam_cairo');					
		wp_enqueue_style('sam_noto_kufi');					
		wp_enqueue_style('sam_style_rtl');
		
	}else{
		
		wp_enqueue_style('sam_bs5');
		wp_enqueue_style('sam_mont');
		wp_enqueue_style('sam_poppins');
		wp_enqueue_style('sam_style');
	}

	// Enqueue Styles
	wp_enqueue_style('sam_fontawesome');
	wp_enqueue_style('sam_aos');
	wp_enqueue_style('sam_swiper');
	
	//Enqueue JS
	wp_enqueue_script('jquery');
	wp_enqueue_script('sam_bs5js');	
	wp_enqueue_script('sam_aosjs');
	wp_enqueue_script('sam_swiperjs');
}